/**
 * Javascript Edit
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
window.FORM_EDIT = (function ($) {
	return {

		// vue
		initVue: null,
		elVue: "#vue-edit",
		elTable: "#edit-table",

		// form
		elForm: ".edit-form",
		elModal: ".edit-modal",
		elModalC: ".edit-modal-content",
		elInputMask: ".inputmasknumber",

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		// url
        urlPrintOut: window.APP.siteUrl + 'adm/sales_orders/print_out/',
        urlIndex: window.APP.siteUrl + 'adm/sales_orders/',
        urlList: window.APP.siteUrl + 'adm/sales_orders/get_embed',
        urlRequestData: window.APP.siteUrl + 'adm/sales_orders/get_data_detail',

		// initial
		init: function () {
			var that = this;

			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					detailData: [],
					paymentMethod: '',
					ppn_status_color: '',
					paid: false,
					totalRemaining: 0,
					totalChange: 0,
				},
				methods: {
					detailAdd: function () {
						// show modal
						var customer = $("#customer-select").val();

						if(customer == ""){
							toastr.warning('Silahkan pilih pelanggan terlebih dahulu!')
						}else{
							$(that.elModal).modal("show");
							$.ajax({
								url: that.urlList,
								success: function (response) {
									$(that.elModalC).html(response);
								}
							});
						}

						$('input[type="checkbox"]').prop('checked', false);
					},

					detailDelete: function () {
						var vue = this;
						var rows = [];
						var arr = vue.detailData;
						// var tr = document.getElementById("table-edit").getElementsByTagName("tr").length;

						// mencari checkbox yg diselect
						var items = $(that.elTable).find('input[class="check-sub"]:checked');
						for (var i = 0; i < items.length; i++) {
							rows.push($(items[i]).val());
						}

						// jika tidak ada yg dipilih
						// munculkan notif
						// sebaliknya menghapus data
						if (!rows.length) {
							toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')
						} else {
							// delete array dari data yg dipilih
							var i;
							for (i = 0; i < arr.length; i++) {
								delete arr[rows[i]];
								// this.detailsSatuan.splice(i, 1);
							}


							that.arrayClean(arr, undefined);
							// update vue data
							setTimeout(function () {
								vue.$set(vue, 'detailData', arr);
								var ii = $('input[type="checkbox"]');
								ii.prop('checked', false);

							}, 100);
						}

						$('input[type="checkbox"]').prop('checked', false);
					},

                    handleData: function () {
                    	var vue = this;
                    	var id = $("#id").val();

                    	$.ajax({
                    		url: that.urlRequestData,
                    		type: 'post',
                    		data: {
                    			'id': id
                    		},
							dataType: "json",
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
                    		success: function (response) {
								vue.$set(vue, 'detailData', response);
								$(that.elVue).unblock();
                    		}
                    	});
					},
					
					handlePayment: function () {
						var vue = this;
						
						$("#payment-method-select").change(function (e) {
							var payment_method = $(e.target).val();
							var customer = $("#customer-select").val();
							var sales_order_date = $("#sales-order-date").val();

							if (customer != "") {
								if (payment_method === "Kredit") {
									vue.handleServicesPayment(customer, sales_order_date);
									vue.$set(vue, 'paymentMethod', payment_method);
								}
								if (payment_method === "Tunai") {
									vue.handleResetPayment();
									vue.$set(vue, 'paymentMethod', payment_method);
								}
							} else {
								toastr.warning('Silahkan pilih Pelanggan terlebih dahulu!');
							}

							setTimeout(function () {
								vue.handlePaid();
							}, 100)
							
						});

						var previousValue;
						$("#customer-select").on('focus', function (e) {
							previousValue = this.value;
						}).change(function () {
							var customer = $(this).val();
							var payment_method = $("#payment-method-select").val();
							var sales_order_date = $("#sales-order-date").val();

							var storedPreviousValue = previousValue;
							if (payment_method == 'Kredit') {
								vue.handleServicesPayment(customer, sales_order_date);
							} else {
								vue.handleResetPayment();
							}

							if (vue.detailData.length > 0) {

								Swal.fire({
									title: 'Anda yakin ingin mengganti Pelanggan?',
									text: "Data item akan direset",
									type: 'warning',
									showCancelButton: true,
									confirmButtonColor: '#3085d6',
									cancelButtonColor: '#d33',
									confirmButtonText: 'Ya, Lanjut!',
									cancelButtonText: 'Batal'
								}).then((result) => {
									if (result.value) {
										vue.detailData.splice(0, vue.detailData.length);
									} else if (result.dismiss == 'cancel') {
										
										if (previousValue != undefined) {
											$("#customer-select").val(storedPreviousValue).trigger('change.select2');
										}
										previousValue = storedPreviousValue;
									}
								})

							}

							previousValue = this.value;
							vue.$set(vue, 'paymentMethod', payment_method);
						});

					},

					handleServicesPayment: function (customer, sales_order_date) {
						$.ajax({
							type: "POST",
							url: window.APP.siteUrl + 'adm/sales_orders/get_payment_term',
							dataType: "JSON",
							data: {
								customer: customer,
								sales_order_date: sales_order_date
							},
							success: function (data) {
								$("#payment-term-text").val(data.payment_term);
								$("#payment-due-text").val(data.payment_due);
							},
						});
					},

					handlePaymentByDays: function (Event) {
						var sales_order_date = $("#sales-order-date").val();

						$.ajax({
							type: "POST",
							url: window.APP.siteUrl + 'adm/sales_orders/get_payment_term_by_days',
							dataType: "JSON",
							data: {
								payment_term: Event,
								sales_order_date: sales_order_date
							},
							success: function (data) {
								$("#payment-due-text").val(data.payment_due);
							},
						});
					},

					handleResetPayment: function () {
						$("#payment-term-text").val("");
						$("#payment-due-text").val("");
					},

					handlePrice: function(row, field_name, value) {
						var vue = this;
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);
						
						vue.$set(row, field_name, value);
						vue.handleCount(row, field_name, value);
					},

					handlePPNStatus: function(row, fieldname, value) {
						var vue = this;
						var total = 0;
						total = (Number(row.result_large) + Number(row.result_medium) + Number(row.result_small));

						var ppn_total = 0
						if(row.ppn_status == '2'){
							ppn_total = (total * 0.10);
							vue.$set(row, 'ppn_status_color', 'bg-success');
						}else if(row.ppn_status == '1'){
							ppn_total = 0;
							vue.$set(row, 'ppn_status_color', '');
						}else{
							ppn_total = 0;
							vue.$set(row, 'ppn_status_color', 'bg-warning');
						}
						vue.$set(row, 'ppn_total', ppn_total);
						vue.$set(row, 'total', (total + ppn_total).toLocaleString("en-US"));
					},
					
					handleCount: function (row, field_name, value, wholesale_done) {
						var vue = this;
						var result_large = 0;
						var result_medium = 0;
						var result_small = 0;
						var total = 0;
						// var discount = 0;
						// var sub_total = 0;

						if (field_name == 'lg_unit_qty' || field_name == 'lg_unit_prc') {
							result_large = (row.lg_unit_qty * row.lg_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_large', result_large);
							if (field_name == 'lg_unit_qty' && wholesale_done != 1) {
								vue.handleWholesalePrice(row, field_name, value);
								vue.handleStock(row, field_name, value);
							}
						}
						if (field_name == 'md_unit_qty' || field_name == 'md_unit_prc') {
							result_medium = (row.md_unit_qty * row.md_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_medium', result_medium);
							vue.handleStock(row, field_name, value);
						}
						if (field_name == 'sm_unit_qty' || field_name == 'sm_unit_prc') {
							result_small = (row.sm_unit_qty * row.sm_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_small', result_small);
							vue.handleStock(row, field_name, value);
						}

						// result_large_total  = (row.result_large  == undefined ? "0" : row.result_large);
						// result_medium_total = (row.result_medium == undefined ? "0" : row.result_medium);
						// result_small_total  = (row.result_small  == undefined ? "0" : row.result_small);
						total = (Number(row.result_large) + Number(row.result_medium) + Number(row.result_small));

						var ppn_total = 0
						if(row.ppn_status == '2'){
							// ppn_total = (total * 0.10);
							var ppn_amount = $("#ppn_amount").val();
							    ppn_total  = (total * (ppn_amount/100));
						}
						vue.$set(row, 'ppn_total', ppn_total);
						vue.$set(row, 'total', (total + ppn_total).toLocaleString("en-US"));
						// discount = total * row.discount / 100;
						// sub_total = total - discount;
						// vue.$set(row, 'total', sub_total.toLocaleString("en-US"));
						// vue.$set(row, 'discount_total', discount.toLocaleString("en-US"));

						// This is the KEY : To Restore If Sometimes Get Error's
						// vue.$set(row, field_name, value);
					},

					handleWholesalePrice: function (row, field_name, value) {
						var vue = this;

						$.ajax({
							type: "POST",
							url: window.APP.siteUrl + 'adm/sales_orders/get_wholesale_price',
							dataType: "JSON",
							data: {
								customer: $("#customer-select").val(),
								item: row.id,
								quantity_large: value
							},
							success: function (data) {
								vue.$set(row, 'lg_unit_prc', data);
								vue.handleCount(row, field_name, value, 1);
							},
						});
					},

					handleStock: function(row, field_name, value) {
						var vue = this;

						lg_calc = 0;
						md_calc = 0;
						sm_calc = 0;

						calc = row.total_stock_stored;
						calc = (calc - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));

						if(calc < 0){
							toastr.warning('Stok tidak mencukupi!');
							if(field_name == 'lg_unit_qty'){
								vue.$set(row, 'lg_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								vue.handleCount(row, field_name, value);
							}
							if(field_name == 'md_unit_qty'){
								vue.$set(row, 'md_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								vue.handleCount(row, field_name, value);
							}
							if(field_name == 'sm_unit_qty'){
								vue.$set(row, 'sm_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								vue.handleCount(row, field_name, value);
							}
						}
						
						var left_stock_large = 0;
						left_stock_large = (calc/row.lg_unit_cnt);

						if(left_stock_large <= row.minimum_stock){
							toastr.error('Barang telah mencapai stok minimum!')
							vue.$set(row, 'bg_min_stock', 'bg-danger');
						}else{
							vue.$set(row, 'bg_min_stock', '');
						}
						
						vue.$set(row, 'total_stock', calc);
					},

					countSubTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var items = vue.detailData;
						// console.log(items);
						for (var i in items) {
							totalAmmount += parseFloat(items[i].total.replace(/,/g, ''));
						}
						vue.handlePaid();
						return totalAmmount.toLocaleString("en-US");
					},

					countPPNTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var items = vue.detailData;
						// console.log(items);
						for (var i in items) {
							totalAmmount += parseFloat(items[i].ppn_total);
						}

						return totalAmmount.toLocaleString("en-US");
					},

					handlePaid: function (Event) {
						var vue = this;
						var payment_method = $("#payment-method-select").val();
						var paid_total = $("#paid_total").val();
						var totalAmmount = 0;
						var items = vue.detailData;

						for (var i in items) {
							totalAmmount += parseFloat(items[i].total.replace(/,/g, ''));
						}
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);

						if(Event != ''){
							if(payment_method == 'Kredit'){
								if(totalAmmount > paid_total.replace(/,/g, '')){
									vue.$set(vue, 'paid', true);
								}else{
									vue.$set(vue, 'paid', false);
								}
							}

							if(payment_method == 'Tunai'){
								if(totalAmmount > paid_total.replace(/,/g, '')){
									vue.$set(vue, 'paid', false);
								}else{
									vue.$set(vue, 'paid', true);
								}
							}
						}

						if(paid_total.replace(/,/g, '') > 0){ 
							paid_total = paid_total.replace(/,/g, '');
						}

						var change    = 0;
						if(paid_total > 0){
							change    = (paid_total - totalAmmount);
						}
						    
						var remaining = 0;
						    remaining = (totalAmmount - paid_total);
						
						$("#change_total").val(change);
						$("#remaining_total").val(remaining);
						$("#remaining_total_show").val('-' +remaining);

						vue.$set(vue, 'totalChange', change);
						vue.$set(vue, 'totalRemaining', remaining);
					},

					handleCheckbox: function () {

						$('#edit-table').on('click', '#check-sub', function () {
							var row     = ($('#edit-table tr').length - 2);
							var checked = $('#edit-table').find('input[class="check-sub"]:checked');
			
							if(row == checked.length){
								$('#check-all').prop('checked', true);
							}else{
								$('#check-all').prop('checked', false);
							}
						});
			
					},
                     
				},
				mounted: function () {
                    var vue = this;
					var id = $("#id").val();
					
                    if(id != 'new'){
						vue.handleData();
					}
					vue.handleCheckbox();
					var paymentMethod = $("#payment-method-select").val();
						vue.$set(vue, 'paymentMethod', paymentMethod);
						vue.handlePayment();

					setTimeout(function () {
						that.handleForm();
						window.INPUT.handleCheckboxAll(that.elParentCheckbox, that.elSubCheckbox);
					}, 500);
					
				}
			});

		},

		// form
		handleForm: function () {
			var that = this;

			window.DATETIME.initDatePicker();

			$(that.elForm).validate();

			$(that.elForm).ajaxForm({
				beforeSend: function () {
					$(that.elVue).block({
						message: '<h4>Please Wait..</h4>'
					});

					if (that.initVue.detailData.length == 0) {
						toastr.warning('Silahkan isi data terlebih dahulu!')
						$(that.elVue).unblock();
						return false;
					}
				},
				data: {
					vuedata: that.initVue.detailData
				},
				dataType: "json",
				success: function (response) {
					$(that.elVue).unblock();

					window.FORM.showNotification(response.message, response.status);

					if (response.status == "success") {
						if(response.btn_action == "finish"){
							setTimeout(function () {
								window.location.href = that.urlPrintOut +response.id
							}, 1500);
						}else{
							setTimeout(function () {
								window.location.href = that.urlIndex
							}, 1500);
						}
					}

				}
			});

        },
        
		/**
		 * Mencari key dan value dari sebuah array yg dihasilkan
		 */
		objectFindByKey: function (array, key, value) {
			var newArr = [];
			for (var i = 0; i < array.length; i++) {
				if (array[i][key] === value) {
					newArr.push(array[i]);
				}

			}
			return newArr;
		},

		arrayClean: function (array, deleteValue) {
			for (var i = 0; i < array.length; i++) {
				if (array[i] == deleteValue) {
					array.splice(i, 1);
					i--;
				}
			}
			return array;
		},
	}
})(jQuery);