<?php
/**
 * Users Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Users_model extends Model {

	public function get_data_user($where = "")
	{
		$sql = $this->db;

		$sql->select("*");
		$sql->from("master_user a");
		$sql->join("master_role b", "a.role_id = b.role_id", "inner");
		
		if ($where != "")
		{
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_role($where = "")
	{
		$sql = $this->db;

		$sql->select("*");
		$sql->from("master_role");
		
		if ($where != "")
		{
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data)
	{
		return $this->db->insert("master_user", $data);
	}

	public function update($id, $data)
	{
		$this->db->where("user_id", $id);
		return $this->db->update("master_user", $data);
	}

	public function delete($id)
	{
		$this->db->where("user_id", $id);
		return $this->db->delete("master_user");
	}

	public function check_id($where)
	{
		$this->db->select("*");
		$this->db->from("master_user");
		$this->db->where($where);

		$query = $this->db->get();
		return $query->result();
	}

}

?>
