<?php
/**
 * Sales Orders Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Sales_orders_model extends Model {

	public function salesorder_autonumber()
	{	
		$sql = $this->db;

		$sql->select('RIGHT(sales_order_headers.sales_order_header_number, 4) as serial_number', FALSE);
		$sql->where('MONTH(sales_order_header_date) = MONTH(CURRENT_DATE())');
		$sql->order_by('sales_order_header_number', 'DESC');
		$sql->limit(1);    
		$query = $sql->get('sales_order_headers');  
		if($query->num_rows() <> 0){         
			$data = $query->row();      
			$serial_number = intval($data->serial_number) + 1;    
		}
		else {          
			$serial_number = 0001;    
		}

		$serial_number_generate = str_pad($serial_number, 4, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function ppn_status($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('master_ppn_status');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function salesorder_header($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('sales_order_headers a');
	    $sql->join('master_customers b', 'b.customer_id = a.sales_order_header_customer_id', 'left');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function salesorder_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('a.*, b.*, 
		c.unit_id as large_unit_id,
		c.unit_name as large_unit_name,
		c.unit_priority as large_unit_pr,
		d.unit_id as medium_unit_id,
		d.unit_name as medium_unit_name,
		d.unit_priority as medium_unit_pr,
		e.unit_id as small_unit_id,
		e.unit_name as small_unit_name,
		e.unit_priority as small_unit_pr,
		');
	    $sql->from('sales_order_details a');
	    $sql->join('master_items b', 'b.item_id = a.sales_order_detail_item_id', 'left');
	    $sql->join('master_units c', 'c.unit_name = b.large_unit', 'left');
	    $sql->join('master_units d', 'd.unit_name = b.medium_unit', 'left');
	    $sql->join('master_units e', 'e.unit_name = b.small_unit', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		

		$get = $sql->get();

		return $get;
	}

	public function salesorder_detail2($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('a.*, b.*, f.*,
		c.unit_id as large_unit_id,
		c.unit_name as large_unit_name,
		c.unit_priority as large_unit_pr,
		d.unit_id as medium_unit_id,
		d.unit_name as medium_unit_name,
		d.unit_priority as medium_unit_pr,
		e.unit_id as small_unit_id,
		e.unit_name as small_unit_name,
		e.unit_priority as small_unit_pr,
		');
	    $sql->from('sales_order_details a');
	    $sql->join('master_items b', 'b.item_id = a.sales_order_detail_item_id', 'left');
	    $sql->join('master_units c', 'c.unit_name = b.large_unit', 'left');
	    $sql->join('master_units d', 'd.unit_name = b.medium_unit', 'left');
	    $sql->join('master_units e', 'e.unit_name = b.small_unit', 'left');
	    $sql->join('sales_order_headers f', 'f.sales_order_header_id = a.sales_order_detail_header_id', 'left');


		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		

		$get = $sql->get();

		return $get;
	}

	public function salesorder_detail_advance($where='', $order='', $group_by='', $where_hed='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('sales_order_details a');
	    $sql->join('sales_order_headers b', 'b.sales_order_header_id = a.sales_order_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.sales_order_detail_item_id', 'left');
	    $sql->join('master_customers d', 'd.customer_id = b.sales_order_header_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function salesorder_detail_sum($where='', $order='', $group_by='', $where_hed='')
	{
		$sql = $this->db;

		$sql->select('*, sum(sales_order_detail_result_large + sales_order_detail_result_medium + sales_order_detail_result_small) as result');
	    $sql->from('sales_order_details a');
		$sql->join('sales_order_headers b', 'b.sales_order_header_id = a.sales_order_detail_header_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function salesorder_headersearch($type='', $customer='', $search='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('sales_order_headers a');
	    $sql->join('master_customers b', 'b.customer_id = a.sales_order_header_customer_id', 'left');

    	if ($search != '')
		{
			$sql->like('sales_order_header_number', $search);
			$sql->or_like('sales_order_header_date', $search);
		}

		$sql->where('sales_order_header_customer_id', $customer);
		$sql->where('status_paid', 0);
		$sql->where('is_hold', 0);
		$sql->order_by('sales_order_header_number ASC');

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('sales_order_headers', $data);
		}

		return $this->db->insert('sales_order_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('sales_order_details', $data);
		}

		return $this->db->insert('sales_order_details', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('sales_order_header_id', $id);
		return $this->db->update('sales_order_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("sales_order_header_id", $id);
		return $this->db->delete("sales_order_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("sales_order_detail_header_id", $id);
		return $this->db->delete("sales_order_details");
	}

	public function truncate_header()
	{
		return $this->db->empty_table("sales_order_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("sales_order_details");
	}

}

?>
