<?php
/**
 * Deposit Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Deposit_model extends Model {

	public function deposit_autonumber()
	{	
		$sql = $this->db;

		$sql->select('RIGHT(deposit.deposit_number, 4) as serial_number', FALSE);
		$sql->where('MONTH(deposit_date) = MONTH(CURRENT_DATE())');
		$sql->order_by('deposit_number', 'DESC');
		$sql->limit(1);    
		$query = $sql->get('deposit');  
		if($query->num_rows() <> 0){         
			$data = $query->row();      
			$serial_number = intval($data->serial_number) + 1;    
		}
		else {          
			$serial_number = 0001;    
		}

		$serial_number_generate = str_pad($serial_number, 4, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function get_data($where="") {
		$sql = $this->db;

		$sql->select("*");
        $sql->from("deposit a");
		$sql->join("master_student b", "b.student_id = a.student_id", "inner");

		$sql->order_by('deposit_number', 'desc');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data) {
		return $this->db->insert('deposit', $data);
	}

	public function update($id, $data) {
		$this->db->where('deposit_id', $id);
		return $this->db->update('deposit', $data);
	}

	public function delete($id) {
		$this->db->where('deposit_id', $id);
		return $this->db->delete('deposit');
	}

	public function check_id($where) {
		$this->db->select("*");
		$this->db->from('deposit');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}

}

?>
