<?php

/**
 * Kelas Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use libraries\BaseController;

class Order extends BaseController
{

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->library('encrypt');

		// load model
		$this->load->model('Order_model');
	}
	
	public function invoice()
	{
		$this->load->library('pdfgenerator');
		  $trx_id = $this->session->userdata('trx_id');
		  $trx_number = $this->session->userdata('trx_number');
// 		  echo $trx_id;
// 		die();

		$data['title_pdf'] = 'Laporan Penjualan Toko Kita';
		$data['header'] = $this->Order_model->get_orders(array('header_id'=> $trx_id))->row_array();
		
		$data['detail'] = $this->Order_model->get_orders_detail(array('header_id'=> $trx_id))->result();

		$file_pdf = 'INVOICE-'.$trx_number;
		$paper = 'A4';
		$orientation = "portrait";

		$html = $this->load->view('invoice', $data, true);
// 		$html = $this->twiggy_display('error404', $data, true);

		// run dompdf
		$this->pdfgenerator->generate($html, $file_pdf, $paper, $orientation);
		
	}

	public function index()
	{
		$table_number = $this->session->userdata('table_number');
		$table_id = $this->encrypt->decode($table_number);

		

		$get_tables    = $this->Order_model->get_tables(array('number' => $table_id))->num_rows();
		
// 		echo $get_tables;
// 		die();

		if ($get_tables != 1 && $table_number != "") {
			redirect("Unauthorized");
		}

		$data['content_title'] = 'Ngopi di Sawah';
		$data['description'] = 'Lorem ipsum dolor sit ametum dilikip inheritence';
		$data['table_number'] = $table_id;

		$this->twiggy_display('adm/order/index', $data);
	}

	public function self_order($table_number = '')
	{

		$this->session->set_userdata('table_number', $table_number);
		if ($table_number != '') {
			$this->index();
		}
	}

	public function get_details()
	{
		$data = [];

		$data['id']          = $this->input->post('id');
		$data['code']        = $this->input->post('code');
		$data['name']        = $this->input->post('name');
		$data['description'] = $this->input->post('description');
		$data['group']       = $this->input->post('group');
		$data['quantity']    = $this->input->post('quantity');
		$data['notes']       = $this->input->post('notes');
		$data['price']       = $this->input->post('price');
		// $data['img_filename'] = base_url('assets/images/upload_file/items/') .$this->input->post('img_filename');
		$data['img_filename'] = $this->input->post('img_filename');
		$data['row'] = $this->input->post('row');
		$data['idx'] = $this->input->post('idx');

		$data['content_title'] = 'Data Barang';

		$this->twiggy_display('adm/order/embed', $data);
	}

	public function get_items()
	{
		// $customer = $this->input->post("customer");
		// $item     = $this->input->post("item");
		// $ppn      = $this->input->post("ppn");
		// $fromdate = $this->input->post("fromdate");
		// $todate   = $this->input->post("todate");

		// $data  = [];
		// $where = [];
		// $order = ("printed_date ASC, sales_order_header_number");

		// if(isset($customer) && $customer != '' && $customer != '(Semua)')
		// {
		// 	$where['sales_order_header_customer_id'] = $customer;
		// }
		// if(isset($item) && $item != '' && $item != '(Semua)')
		// {
		// 	$where['sales_order_detail_item_id'] = $item;
		// }
		// if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		// {
		// 	$where['sales_order_detail_ppn_status'] = $ppn;
		// }
		// if(isset($fromdate) && $fromdate != '')
		// {
		// 	$where['printed_date >='] = change_format_date($fromdate);
		// }
		// if(isset($todate) && $todate != '')
		// {
		// 	$where['printed_date <='] = change_format_date($todate);
		// }
		$def_img     = 'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9InllcyI/PjxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB3aWR0aD0iNjQiIGhlaWdodD0iNjQiIHZpZXdCb3g9IjAgMCA2NCA2NCIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSI+PGRlZnMvPjxyZWN0IHdpZHRoPSI2NCIgaGVpZ2h0PSI2NCIgZmlsbD0iI0VFRUVFRSIvPjxnPjx0ZXh0IHg9IjEzLjQ2MDkzNzUiIHk9IjMyIiBzdHlsZT0iZmlsbDojQUFBQUFBO2ZvbnQtd2VpZ2h0OmJvbGQ7Zm9udC1mYW1pbHk6QXJpYWwsIEhlbHZldGljYSwgT3BlbiBTYW5zLCBzYW5zLXNlcmlmLCBtb25vc3BhY2U7Zm9udC1zaXplOjEwcHQ7ZG9taW5hbnQtYmFzZWxpbmU6Y2VudHJhbCI+NjR4NjQ8L3RleHQ+PC9nPjwvc3ZnPg==';
		$get_data    = $this->Order_model->get_items_group()->result();

		$grand_total = 0;

		// ketika data tersedia
		// maka generate data json untuk Datatable

		if ($get_data) {
			$no = 1;
			foreach ($get_data as $k => $get_row) {

				$data[] = array(
					'group' => $get_row->name
				);

				$where['a.id_group'] = $get_row->id_group;
				$gdata_detail = $this->Order_model->get_items($where)->result();


				$rowspan = 1;

				foreach ($gdata_detail as $key => $value) {
					$set_img = $value->img_filename != "" ? "https://admin.ngopidisawah.com/assets/images/upload_file/items/" . $value->img_filename : $def_img;

					$data[$k]['detail'][$key] = array(
						'no'           => $no,
						'id'           => $value->id,
						'code'         => $value->code,
						'name'         => $value->name,
						'description'  => $value->description,
						'unit'         => $value->unit,
						'group'        => $value->group_name,
						'quantity'     => 0,
						'notes'        => '',
						'price'        => number_format($value->price),
						'img_filename' => $set_img,
						'status'       => $value->status,
					);
				}
				$no++;
			}
		}

		$response = [
			'detail_data' => $data
		];

		output_json($response);
	}

	public function get_items_backuop()
	{
		$search = $this->input->post('search');
		$data     = [];
		$response = [];

		$get_data = $this->Order_model->get_items(array("status" => "1"), $search)->result();

		$no = 0;
		foreach ($get_data as $row) {
			$data['food'] = array(
				'no'           => $no,
				'id'           => $row->id,
				'code'         => $row->code,
				'name'         => $row->name,
				'description'  => $row->description,
				'unit'         => $row->unit,
				'group'        => $row->group,
				'quantity'     => 0,
				'notes'        => '',
				'price'        => number_format($row->price),
				'img_filename' => $row->img_filename,
				'status'       => $row->status,

			);

			$no++;
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id = 'new')
	{
		$title    = "Tambah";
		$get_data = array();

		if ($id != 'new') {
			$title    = "Edit";
			$where = array('id_kelas' => $id);
			$get_data = $this->Kelas_model->get_data($where)->row_array();
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;
		$data['pegawai_data']  = $this->Pegawai_model->get_data(array('a.id_grup' => 2))->result();

		$this->twiggy_display('adm/kelas/edit', $data);
	}

	public function save()
	{
		date_default_timezone_set('Asia/Jakarta');
		$table_number = $this->session->userdata('table_number');

		$prefix           = "ORD";
		$datenow          = date('Ym');
		$number_generator = $this->Order_model->autonumber();
		$autonumber       = $prefix . $datenow . $number_generator;

		$number       = $autonumber;
		$date         = date_now();
		$type_order   = $this->input->post("type_order");
		$on_behalf    = $this->input->post("on_behalf");
		$grand_total  = $this->input->post("grand_total");


		$vuedata = $this->input->post('vuedata');
		$header_id = 0;

		$header_data = [
			'number'       => $number,
			'date'         => $date,
			'type_order'   => $type_order,
			'on_behalf'    => $on_behalf,
			'table_number' => $this->encrypt->decode($table_number),
			'grand_total'  => trims($grand_total)
		];
		$detail_data = [];

		$save_header = $this->Order_model->save_header($header_data);

		if ($save_header) {
			$header_id = $this->db->insert_id();
			foreach ($vuedata as $row) {
				$detail_data[] = [
					'header_id' => $header_id,
					'item_id'   => $row['id'],
					'item_code' => $row['code'],
					'item_name' => $row['name'],
					'quantity'  => trims($row['quantity']),
					'price'     => trims($row['price']),
					'total'     => trims($row['total']),
					'notes'     => $row['notes'],

				];
			}

			$save_detail = $this->Order_model->save_detail($detail_data, true);

			if ($save_detail) {
				$msg    = "Berhasil menyimpan data";
				$status = "success";

				$this->session->set_userdata('trx_id', $header_id);
				$this->session->set_userdata('trx_number', $number);
			} else {
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		} else {
			$msg    = "Gagal menyimpan data";
			$status = "error";
		}

		$response = [
			'message' => $msg,
			'status'  => $status
		];
		output_json($response);
	}

	public function delete()
	{
		$id = $this->input->post('id');

		foreach ($id as $row) {
			$delete_type = $this->Kelas_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id()
	{
		$code  = $this->input->post('id');
		$where = array('nama_kelas' => $code);

		$check = $this->Kelas_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}
}
