<?php
/**
 * Point Requirements Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Ptsreqs extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Ptsreqs_model');
		$this->load->model('Items_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
		$data['content_title'] = 'Ketentuan Poin';
		
		$this->twiggy_display('adm/ptsreqs/index', $data);
	}
	 
	public function get_data_header()
	{	
		$data = [];
		$where = array('ptsreq_header_period_end >=' => date_now());
		$order = "ptsreq_header_name ASC";
		$get_data = $this->Ptsreqs_model->ptsreq_header($where, $order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$data[] = array(
					'no'          => $no,
					'id'          => $get_row->ptsreq_header_id,
					'name'        => $get_row->ptsreq_header_name,
					'start_date'  => indonesian_date($get_row->ptsreq_header_period_start),
					'end_date'    => indonesian_date($get_row->ptsreq_header_period_end),
					'total_point' => $get_row->ptsreq_header_total,
					'description' => $get_row->ptsreq_header_description,
				);
				$no++;
			}
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

        output_json($response);
	}

 	public function edit($id = 'new')
	{
		$title = "Tambah Kententuan Poin";
		$header_data = array(null);

		$name        = '';
		$start_date  = date_now();
		$end_date    = date_now();
		$total_point = '';
		$description  = '';

	    if($id != 'new')
	    {
			$title       = "Edit ketentuan Poin";
			$where       = array('ptsreq_header_id' => $id);
			$header_data = $this->Ptsreqs_model->ptsreq_header($where)->row_array();
			$name        = $header_data['ptsreq_header_name'];
			$start_date  = $header_data['ptsreq_header_period_start'];
			$end_date    = $header_data['ptsreq_header_period_end'];
			$total_point = $header_data['ptsreq_header_total'];
			$description  = $header_data['ptsreq_header_description'];
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		// $data['header_data']   = $header_data;

		$data['name']        = $name;
		$data['start_date']  = $start_date;
		$data['end_date']    = $end_date;
		$data['total_point'] = $total_point;
		$data['description']  = $description;

		$this->twiggy_display('adm/ptsreqs/edit', $data);
	}

	public function get_data_detail()
	{	
		$id    = $this->input->post("id");
		$where = array('ptsreq_detail_header_id' => $id);
		$order = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Ptsreqs_model->ptsreq_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{

				$data[] = array(
					'no'               => $no,
					'detail_id'        => $get_row->ptsreq_detail_id,
					'detail_header_id' => $get_row->ptsreq_detail_header_id,
					'id'               => $get_row->ptsreq_detail_item_id,
					'name'             => $get_row->ptsreq_detail_item_name,
					'lg_unit'          => $get_row->ptsreq_detail_large_unit,
					'lg_unit_qty'      => to_decimal($get_row->ptsreq_detail_large_quantity),
					'lg_unit_prc'      => number_format($get_row->ptsreq_detail_large_unit_price)
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Barang';
		$this->twiggy_display('adm/ptsreqs/embed', $data);
	}

	public function get_data_embed()
	{
		$data = [];
		$response = [];
		$search   = $this->input->post('search');

		$get_data  = $this->Items_model->get_data_search($search)->result();

		$no = 0;
		foreach($get_data as $get_row)
		{	
			$data[] = array(
				'no'               => $no,
				'id'               => $get_row->item_id,
				'name'             => $get_row->item_name,
				'group_id'         => $get_row->group_id,
				'group_name'       => $get_row->group_name,
				'group_child_id'   => $get_row->group_child_id,
				'group_child_name' => $get_row->group_child_name,
				'lg_unit'          => $get_row->large_unit,
				'btncolor'         => '',
				'btnicon'          => '',
			);

			$no++;
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

		output_json($response);
		
	}

	public function save()
	{	
		$id          = $this->input->post('id');
		$name        = $this->input->post("name");
		$start_date  = $this->input->post("start_date");
		$end_date    = $this->input->post("end_date");
		$total_point = $this->input->post("total_point");
		$description = $this->input->post("description");
		
		$vuedata = $this->input->post('vuedata');

		$header_id   = $id;
		$header_data = [
			'ptsreq_header_name'         => $name,
			'ptsreq_header_period_start' => change_format_date($start_date),
			'ptsreq_header_period_end'   => change_format_date($end_date),
			'ptsreq_header_total'        => $total_point,
			'ptsreq_header_description'  => $description,
		];

		$detail_data = [];
		$log_data = [];

		// if save $id = new else update data
		if($id == "new")
		{
			// save header
			$save_header = $this->Ptsreqs_model->save_header($header_data);
			if($save_header)
			{
				$header_id = $this->db->insert_id();
				foreach($vuedata as $row)
				{
					$detail_data[] = [
						'ptsreq_detail_header_id'        => $header_id,
						'ptsreq_detail_item_id'          => $row['id'],
						'ptsreq_detail_item_name'        => $row['name'],
						'ptsreq_detail_large_unit'       => $row['lg_unit'],
						'ptsreq_detail_large_quantity'   => trims($row['lg_unit_qty']),
						'ptsreq_detail_large_unit_price' => trims($row['lg_unit_prc'])
					];
				}
				
				$save_detail = $this->Ptsreqs_model->save_detail($detail_data, true);
				
				if($save_detail)
				{	
					$msg    = "Berhasil menyimpan data";
					$status = "success";
				}
				else
				{
					$msg    = "Gagal menyimpan data";
					$status = "error";	
				}
			}
			else
			{
				$msg    = "Gagal menyimpan data";
				$status = "error";	
			}
			
		}else{
			
			$delete_detail = $this->Ptsreqs_model->delete_detail($id);

			if ($delete_detail) {
				$save_header = $this->Ptsreqs_model->update_header($id, $header_data);

				if($save_header)
				{
					// $header_id = $this->db->insert_id();
					foreach($vuedata as $row)
					{
						$detail_data[] = [
							'ptsreq_detail_header_id'        => $id,
							'ptsreq_detail_item_id'          => $row['id'],
							'ptsreq_detail_item_name'        => $row['name'],
							'ptsreq_detail_large_unit'       => $row['lg_unit'],
							'ptsreq_detail_large_quantity'   => trims($row['lg_unit_qty']),
							'ptsreq_detail_large_unit_price' => trims($row['lg_unit_prc'])
						];
					}

					$save_detail = $this->Ptsreqs_model->save_detail($detail_data, true);

					if($save_detail)
					{
						$msg    = "Berhasil menyimpan data";
						$status = "success";
					}
					else
					{
						$msg    = "Gagal menyimpan data";
						$status = "error";	
					}
				}else{
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);

	}

	public function delete()
	{
		$id = $this->input->post('id');
		$data_log = [];
		foreach($id as $row)
		{	
			$delete_header = $this->Ptsreqs_model->delete_header($row);

			if($delete_header){
				$delete_type = $this->Ptsreqs_model->delete_detail($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out($id)
	{	
		$where_header = array('ptsreq_header_id' => $id);
		$where_detail = array('ptsreq_detail_header_id' => $id);

		$header = $this->Ptsreqs_model->ptsreq_header($where_header)->row_array();
		$detail = $this->Ptsreqs_model->ptsreq_detail($where_detail)->result();

		$data['content_title'] = 'Print Ketentuan Poin';
		$data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/ptsreqs/print_out', $data);
	}

}

?>
