<?php
/**
 * Report Profits Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Report_profits extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Sales_orders_model');
		$this->load->model('Customers_model');
		$this->load->model('Items_model');
		$this->load->model('Logs_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Laba';
        $data['customer_data'] = $this->Customers_model->get_data()->result();
        $data['item_data']     = $this->Items_model->get_data()->result();
		
		$this->twiggy_display('adm/report_profits/index', $data);
	}

	public function get_data_detail()
	{	
		$customer = $this->input->post("customer");
		$item     = $this->input->post("item");
		$ppn      = $this->input->post("ppn");
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");

        $data  = [];
		$where = [];
		$order = ("sales_order_header_date ASC, sales_order_header_number");
		// $order = ("c.timestamp ASC, sales_order_header_number");

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['sales_order_header_customer_id'] = $customer;
		}
		if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['sales_order_detail_item_id'] = $item;
		}
		if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
			$where['sales_order_detail_ppn_status'] = $ppn;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['printed_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['printed_date <='] = change_format_date($todate);
		}

		$where['is_hold'] = 0;
		
		$get_data     = $this->Sales_orders_model->salesorder_detail_advance2($where, $order, 'a.sales_order_detail_header_id')->result();

		
		$gt_penjualan = 0;
		$gt_modal     = 0;
		$gt_margin    = 0;

		// ketika data tersedia
		// maka generate data json untuk Datatable
		$line = 1;
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $k => $get_row)
			{	


				$where['sales_order_header_id'] = $get_row->sales_order_header_id;
		
				$gdata_detail = $this->Sales_orders_model->salesorder_detail_advance2($where, '', '')->result();

				$data[] = array(
					'number'        => $no,
					'number_length' => count($gdata_detail) - 1,
					'sales_number'  => $get_row->sales_order_header_number,
					'customer'  => "XXX",
				);

				$rowspan = 1;
				$a = 0;
				$b = 0;
				$c = 0;
				foreach ($gdata_detail as $key => $value) {
					
					$ppn_status       = $get_row->sales_order_detail_ppn_status;
					$ppn_status_color = '';

					if($ppn_status == '2'){
						$ppn_status_color = 'cl-success';
					}
					if($ppn_status == '3'){
						$ppn_status_color = 'cl-warning';
					}

					$lg_unit = '';
					$md_unit = '';
					$sm_unit = '';

					$lg_unit_qty = 0;
					$md_unit_qty = 0;
					$sm_unit_qty = 0;

					$lg_unit_prc = 0;
					$md_unit_prc = 0;
					$sm_unit_prc = 0;

					$lg_unit_mar = 0;
					$md_unit_mar = 0;
					$sm_unit_mar = 0;

					$lg_unit_cap_new = 0;
					$md_unit_cap_new = 0;
					$sm_unit_cap_new = 0;

					// $where_log = array('log_type' => 'SELL', 'log_transaction_id' => $value->sales_order_header_id, 'log_item_id' => $value->sales_order_detail_item_id);
					// $get_log   = $this->Sales_orders_model->get_log($where_log)->row();
					
					

					if($value->sales_order_detail_large_unit_quantity > 0){
						$lg_unit     = $value->sales_order_detail_large_unit;

						$lg_unit_cap_new = $value->log_large_unit_purchase_price;
						

						$lg_unit_qty = to_decimal($value->sales_order_detail_large_unit_quantity);
						$lg_unit_prc = ($value->sales_order_detail_large_unit_price);
						$lg_unit_mar = (($value->sales_order_detail_large_unit_price) - ($lg_unit_cap_new));

					}

					if($value->sales_order_detail_medium_unit_quantity > 0){
						$md_unit     = $value->sales_order_detail_medium_unit;

						$md_unit_cap_new = $value->log_medium_unit_purchase_price;
						

						$md_unit_qty = to_decimal($value->sales_order_detail_medium_unit_quantity);
						$md_unit_prc = ($value->sales_order_detail_medium_unit_price);
						$md_unit_mar = (($value->sales_order_detail_medium_unit_price) - ($md_unit_cap_new));

					}

					if($value->sales_order_detail_small_unit_quantity > 0){
						$sm_unit     = $value->sales_order_detail_small_unit;

						$sm_unit_cap_new = $value->log_small_unit_purchase_price;

						$sm_unit_qty = to_decimal($value->sales_order_detail_small_unit_quantity);
						$sm_unit_prc = ($value->sales_order_detail_small_unit_price);
						$sm_unit_mar = (($value->sales_order_detail_small_unit_price) - ($sm_unit_cap_new));

					}
					
					$data[$k]['detail'][$key] = array(
						'no'               => $no,
						'detail_rowspan'   => $rowspan,
						'detail_line'      => $line,

						'sales_number'     => $value->sales_order_header_number,
						'customer'         => $this->Customers_model->get_data(array('customer_id' => $value->sales_order_header_customer_id))->row()->customer_name,
						'sales_date'       => change_format_date($value->sales_order_header_date, 'd/m/Y'),
						'item_name'        => $value->sales_order_detail_item_name,
						
						'lg_unit'          => $lg_unit,
						'lg_unit_qty'      => $lg_unit_qty,
						'lg_unit_prc'      => number_format($lg_unit_prc),
						'lg_unit_cap'      => number_format($lg_unit_cap_new),
						'lg_unit_mar'      => number_format($lg_unit_mar),
						'lg_unit_txt'      => ($lg_unit_mar  > 0 ? '' : 'text-danger'),

						'md_unit'          => $md_unit,
						'md_unit_qty'      => $md_unit_qty,
						'md_unit_prc'      => number_format($md_unit_prc),
						'md_unit_cap'      => number_format($md_unit_cap_new),
						'md_unit_mar'      => number_format($md_unit_mar),
						'md_unit_txt'      => ($md_unit_mar  > 0 ? '' : 'text-danger'),

						'sm_unit'          => $sm_unit,
						'sm_unit_qty'      => $sm_unit_qty,
						'sm_unit_prc'      => number_format($sm_unit_prc),
						'sm_unit_cap'      => number_format($sm_unit_cap_new),
						'sm_unit_mar'      => number_format($sm_unit_mar),
						'sm_unit_txt'      => ($sm_unit_mar  > 0 ? '' : 'text-danger'),

						'ppn_status_color' => $ppn_status_color,
						'total'            => number_format(($lg_unit_qty * $lg_unit_prc) + ($md_unit_qty * $md_unit_prc) + ($sm_unit_qty * $sm_unit_prc)),
						'total_cap'        => number_format(($lg_unit_qty * $lg_unit_cap_new) + ($md_unit_qty * $md_unit_cap_new) + ($sm_unit_qty * $sm_unit_cap_new)),
						'total_mar'        => number_format(($lg_unit_qty * $lg_unit_mar) + ($md_unit_qty * $md_unit_mar) + ($sm_unit_qty * $sm_unit_mar)),
						'ttl_unit_txt'     => (($lg_unit_qty * $lg_unit_mar) + ($md_unit_qty * $md_unit_mar) + ($sm_unit_qty * $sm_unit_mar) > 0 ? '' : 'bg-danger'),
						// 'total'            => number_format($value->sales_order_detail_total),
						'status'    	   => $value->sales_order_detail_ppn_status,

						'grandTotal'    => number_format($a += ($lg_unit_qty * $lg_unit_prc) + ($md_unit_qty * $md_unit_prc) + ($sm_unit_qty * $sm_unit_prc)),
						'grandTotalCap' => number_format($b += ($lg_unit_qty * $lg_unit_cap_new) + ($md_unit_qty * $md_unit_cap_new) + ($sm_unit_qty * $sm_unit_cap_new)),
						'grandTotalMar' => number_format($c += ($lg_unit_qty * $lg_unit_mar) + ($md_unit_qty * $md_unit_mar) + ($sm_unit_qty * $sm_unit_mar)),
					);
					$rowspan++;
					$line++;

					$gt_penjualan += ($lg_unit_qty * $lg_unit_prc) + ($md_unit_qty * $md_unit_prc) + ($sm_unit_qty * $sm_unit_prc);
					$gt_modal     += ($lg_unit_qty * $lg_unit_cap_new) + ($md_unit_qty * $md_unit_cap_new) + ($sm_unit_qty * $sm_unit_cap_new);
					$gt_margin    += ($lg_unit_qty * $lg_unit_mar) + ($md_unit_qty * $md_unit_mar) + ($sm_unit_qty * $sm_unit_mar);
				}
				$no++;
				
                
			}
		}
		$this->session->set_userdata('customer', $customer);
		$this->session->set_userdata('item', $item);
		$this->session->set_userdata('ppn', $ppn);
		$this->session->set_userdata('fromdate', $fromdate);
		$this->session->set_userdata('todate', $todate);

		$response = [
			// 'date_1'                       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'                       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
			'detail_data'         => $data,
			'gt_penjualan' => number_format($gt_penjualan),
			'gt_modal'     => number_format($gt_modal),
			'gt_margin'    => number_format($gt_margin),
		];

		output_json($response);

		// output_json($data);
	}

	public function export_excel() {

		$customer = $this->session->userdata('customer');
		$item     = $this->session->userdata('item');
		$ppn      = $this->session->userdata('ppn');
		$fromdate = $this->session->userdata('fromdate');
		$todate   = $this->session->userdata('todate');

		$where    = [];
		$order = ("sales_order_header_date ASC, sales_order_header_number");
		$customer_name = '-';
		$item_name = '-';

		$fromdate_text = ($fromdate == '' ? '-' : change_format_date($fromdate, 'd/m/Y'));
		$todate_text = ($todate == '' ? '-' : change_format_date($todate, 'd/m/Y'));

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['sales_order_header_customer_id'] = $customer;
			$customer_name = $this->Customers_model->get_data(array('customer_id' => $customer))->row()->customer_name;
		}
		if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['sales_order_detail_item_id'] = $item;
			$item_name = $this->Items_model->get_data(array('item_id' => $item))->row()->item_name;
		}
		if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
			$where['sales_order_detail_ppn_status'] = $ppn;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['sales_order_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['sales_order_header_date <='] = change_format_date($todate);
		}
		
		$get_data = $this->Sales_orders_model->salesorder_detail_advance($where, $order)->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("LABA")
							   ->setSubject("LABA")
							   ->setDescription("LABA")
							   ->setKeywords("LABA");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

		$style_row_success = array(
			'font'  => array(
				'color' => array('rgb' => 'FFFFFF'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '5cb85c')
			)
		);

		$style_row_warning = array(
			'font'  => array(
				'color' => array('rgb' => '000000'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'f0ad4e')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "LABA");
	    $excel->getActiveSheet()->mergeCells('A1:O1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Pelanggan");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$customer_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Nama Barang");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$item_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A5', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B5', ": ".$fromdate_text." - ".$todate_text);

	    $excel->getActiveSheet()->mergeCells('A7:A8');
		$excel->getActiveSheet()->mergeCells('B7:B8');
		$excel->getActiveSheet()->mergeCells('C7:C8');
		$excel->getActiveSheet()->mergeCells('D7:D8');

		$excel->getActiveSheet()->mergeCells('E7:G7');
		$excel->getActiveSheet()->mergeCells('H7:J7');
		$excel->getActiveSheet()->mergeCells('K7:M7');

		$excel->getActiveSheet()->mergeCells('N7:N8');
		$excel->getActiveSheet()->mergeCells('O7:O8');

	    $excel->setActiveSheetIndex(0)->setCellValue('A7', "Nomor Penjualan");
	    $excel->setActiveSheetIndex(0)->setCellValue('B7', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('C7', "Pelanggan");
	    $excel->setActiveSheetIndex(0)->setCellValue('D7', "Nama Barang");
	    $excel->setActiveSheetIndex(0)->setCellValue('E7', "Satuan Besar");
		$excel->setActiveSheetIndex(0)->setCellValue('F7', "Satuan Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('G7', "Satuan Kecil");

		$excel->setActiveSheetIndex(0)->setCellValue('E8', "Satuan");
		$excel->setActiveSheetIndex(0)->setCellValue('F8', "Quantity");
		$excel->setActiveSheetIndex(0)->setCellValue('G8', "Harga");
		$excel->setActiveSheetIndex(0)->setCellValue('H8', "Satuan");
		$excel->setActiveSheetIndex(0)->setCellValue('I8', "Quantity");
		$excel->setActiveSheetIndex(0)->setCellValue('J8', "Harga");
		$excel->setActiveSheetIndex(0)->setCellValue('K8', "Satuan");
		$excel->setActiveSheetIndex(0)->setCellValue('L8', "Quantity");
		$excel->setActiveSheetIndex(0)->setCellValue('M8', "Harga");

		$excel->setActiveSheetIndex(0)->setCellValue('N7', "Total Harga");
		$excel->setActiveSheetIndex(0)->setCellValue('O7', "Status");
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A7:A8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('B7:B8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('C7:C8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('D7:D8')->applyFromArray($style_col);
		
	    $excel->getActiveSheet()->getStyle('E7:G7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('H7:J7')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('K7:M7')->applyFromArray($style_col);
		
	    $excel->getActiveSheet()->getStyle('E8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('F8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('G8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('H8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('I8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('J8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('K8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('L8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('M8')->applyFromArray($style_col);

	    $excel->getActiveSheet()->getStyle('N7:N8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('O7:O8')->applyFromArray($style_col);


	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 9; // Set baris pertama untuk isi tabel adalah baris ke 9
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
		
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->sales_order_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, change_format_date($get_row->sales_order_header_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->sales_order_detail_item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, ($get_row->sales_order_detail_large_unit_quantity  > 0 ? $get_row->sales_order_detail_large_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, ($get_row->sales_order_detail_large_unit_quantity  > 0 ? to_decimal($get_row->sales_order_detail_large_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, ($get_row->sales_order_detail_large_unit_quantity  > 0 ? number_format($get_row->sales_order_detail_large_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, ($get_row->sales_order_detail_medium_unit_quantity > 0 ? $get_row->sales_order_detail_medium_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, ($get_row->sales_order_detail_medium_unit_quantity > 0 ? to_decimal($get_row->sales_order_detail_medium_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, ($get_row->sales_order_detail_medium_unit_quantity > 0 ? number_format($get_row->sales_order_detail_medium_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, ($get_row->sales_order_detail_small_unit_quantity  > 0 ? $get_row->sales_order_detail_small_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('L'.$numrow, ($get_row->sales_order_detail_small_unit_quantity  > 0 ? to_decimal($get_row->sales_order_detail_small_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('M'.$numrow, ($get_row->sales_order_detail_small_unit_quantity  > 0 ? number_format($get_row->sales_order_detail_small_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('N'.$numrow, number_format($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small));
			// $excel->setActiveSheetIndex(0)->setCellValue('N'.$numrow, number_format($get_row->sales_order_detail_total));
			$excel->setActiveSheetIndex(0)->setCellValue('O'.$numrow, $get_row->sales_order_detail_ppn_status);


			// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			// $ppn_status       = $get_row->sales_order_detail_ppn_status;

			$excel->getActiveSheet()->getStyle('A'.$numrow.':O'.$numrow)->applyFromArray($style_row);
			// if($ppn_status == '2'){
			// 	$excel->getActiveSheet()->getStyle('A'.$numrow.':N'.$numrow)->applyFromArray($style_row_success);
			// }
			// if($ppn_status == '3'){
			// 	$excel->getActiveSheet()->getStyle('A'.$numrow.':N'.$numrow)->applyFromArray($style_row_warning);
			// }

			$excel->getActiveSheet()->getStyle('G'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('J'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('M'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('N'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("LABA");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'LABA_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
