<?php
/**
 * Purchase Return Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Purchase_returns extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Purchase_returns_model');
		$this->load->model('Purchase_orders_model');
		// $this->load->model('Customers_model');
		// $this->load->model('Items_model');
		$this->load->model('Logs_model');
		// $this->load->model('Wholesale_prices_model');
		// $this->load->model('Special_prices_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
		$data['content_title'] = 'Retur Pembelian';
		$this->twiggy_display('adm/purchase_returns/index', $data);
	}
	 
	public function get_data_header()
	{	
		$data = [];
		$order = "purchase_return_header_date DESC, purchase_return_header_number";
		$get_data = $this->Purchase_returns_model->purchasereturn_header('', $order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$data[] = array(
					'no'          => $no,
					'id'          => $get_row->purchase_return_header_id,
					'po_id'       => $get_row->purchase_order_header_id,
					'number'      => $get_row->purchase_return_header_number,
					'date'        => indonesian_date($get_row->purchase_return_header_date),
					'supplier'    => $get_row->supplier_name,
					'total'       => number_format($get_row->purchase_return_header_grand_total),
					'description' => $get_row->purchase_return_header_description,
				);
				$no++;
			}
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

        output_json($response);
	}

	public function edit($id = 'new')
	{
		$title = "Tambah Retur Pembelian";
		$return_data = array(null);

		$where       = array('purchase_order_header_id' => $id);
		$return_data = $this->Purchase_returns_model->purchasereturn_header($where)->row_array();
		$purchs_data = $this->Purchase_orders_model->purchaseorder_header($where)->row_array();

		$trx_id      = ($return_data == '' ? 'new' : 'edit');
		$rtr_id		 = 'new';
		$po_number   = $purchs_data['purchase_order_header_number'];
		$po_date     = change_format_date($purchs_data['purchase_order_header_date'], 'd/m/Y');
		$po_supplier = $purchs_data['supplier_name'];
		$po_supplier_id = $purchs_data['supplier_id'];

		$rt_number = "R-" .$purchs_data['purchase_order_header_number'];
		$rt_date   = date_now();
		$rt_description = '';

		$tmstamp   = date("H:i:s");

	    if($trx_id == 'edit')
	    {
			$title     = "Edit Retur Pembelian";
			$rtr_id    = $return_data['purchase_return_header_id'];
			$rt_number = $return_data['purchase_return_header_number'];
			$rt_date   = $return_data['purchase_return_header_date'];
			$rt_description = $return_data['purchase_return_header_description'];
			$tmstamp     = time24($return_data['tmstamp_so']);
		}

		$data['id']            = $id;
		$data['trx_id']        = $trx_id;
		$data['rtr_id']        = $rtr_id;
		$data['content_title'] = $title;

		$data['po_number']      = $po_number;
		$data['po_date']        = $po_date;
		$data['po_supplier_id'] = $po_supplier_id;
		$data['po_supplier']    = $po_supplier;
		$data['rt_number']      = $rt_number;
		$data['rt_date']        = $rt_date;
		$data['rt_description'] = $rt_description;
		$data['tmstamp']         = $tmstamp;

		$this->twiggy_display('adm/purchase_returns/edit', $data);
	}

	public function get_data_detail()
	{	
		$id     = $this->input->post("id");
		$trx_id = $this->input->post("trx_id");
		$where  = array('purchase_order_detail_header_id' => $id);
		$order  = array('item_name' => 'asc');

		$data = [];
		

		$get_data = $this->Purchase_orders_model->purchaseorder_detail($where)->result();
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{
				$large_unit_quantity  = 0;
				$medium_unit_quantity = 0;
				$small_unit_quantity  = 0;
				$result_large  = 0;
				$result_medium = 0;
				$result_small  = 0;
				$total = 0;

				$large_price_order = number_format($get_row->purchase_order_detail_large_unit_price);
				$medium_price_order = number_format($get_row->purchase_order_detail_medium_unit_price);
				$small_price_order  = number_format($get_row->purchase_order_detail_small_unit_price);
				if($trx_id == 'edit'){
					$where_return         = array('purchase_order_header_id' => $id, 'purchase_return_detail_item_id' => $get_row->purchase_order_detail_item_id);
					$get_data_return      = $this->Purchase_returns_model->purchasereturn_detail($where_return)->row_array();
					$large_unit_quantity  = to_decimal($get_data_return['purchase_return_detail_large_unit_quantity']);
					$medium_unit_quantity = to_decimal($get_data_return['purchase_return_detail_medium_unit_quantity']);
					$small_unit_quantity  = to_decimal($get_data_return['purchase_return_detail_small_unit_quantity']);
					$result_large  = number_format($get_data_return['purchase_return_detail_result_large']);
					$result_medium = number_format($get_data_return['purchase_return_detail_result_medium']);
					$result_small  = number_format($get_data_return['purchase_return_detail_result_small']);
					$large_price_order = number_format($get_data_return['purchase_return_detail_large_unit_price']);
					$medium_price_order = number_format($get_data_return['purchase_return_detail_medium_unit_price']);
					$small_price_order  = number_format($get_data_return['purchase_return_detail_small_unit_price']);
					$total = number_format($get_data_return['purchase_return_detail_total']);
				}

				$medium_price_order = ($medium_price_order == "0" ? (($get_row->purchase_order_detail_large_unit_price / to_decimal($get_row->large_unit_contain) * to_decimal($get_row->medium_unit_contain))) : $medium_price_order);
				$small_price_order  = ($small_price_order == "0" ? ($get_row->purchase_order_detail_large_unit_price / to_decimal($get_row->large_unit_contain)) : $small_price_order);

				$total_stock = (($get_row->large_unit_contain * $get_row->purchase_order_detail_large_unit_quantity) 
								+ ($get_row->medium_unit_contain * $get_row->purchase_order_detail_medium_unit_quantity) 
								+ ($get_row->small_unit_contain * $get_row->purchase_order_detail_small_unit_quantity));

				$data[] = array(
					'no'                => $no,
					'detail_id'         => $get_row->purchase_order_detail_id,
					'detail_header_id'  => $get_row->purchase_order_detail_header_id,
					'id'                => $get_row->purchase_order_detail_item_id,
					'name'              => $get_row->purchase_order_detail_item_name,
					'lg_unit'           => $get_row->purchase_order_detail_large_unit,
					'lg_unit_cnt'       => to_decimal($get_row->large_unit_contain),
					'lg_unit_qty' 		=> $large_unit_quantity,
					'lg_unit_qty_order' => to_decimal($get_row->purchase_order_detail_large_unit_quantity),
					'lg_unit_prc'       => $large_price_order,
					'result_large'      => $result_large,
					'md_unit'           => $get_row->purchase_order_detail_medium_unit,
					'md_unit_cnt'       => to_decimal($get_row->medium_unit_contain),
					'md_unit_qty' 		=> $medium_unit_quantity,
					'md_unit_qty_order' => to_decimal($get_row->purchase_order_detail_medium_unit_quantity),
					'md_unit_prc'       => $medium_price_order,
					'result_medium'     => $result_medium,
					'sm_unit'           => $get_row->purchase_order_detail_small_unit,
					'sm_unit_cnt'       => to_decimal($get_row->small_unit_contain),
					'sm_unit_qty' 		=> $small_unit_quantity,
					'sm_unit_qty_order' => to_decimal($get_row->purchase_order_detail_small_unit_quantity),
					'sm_unit_prc'       => $small_price_order,
					'result_small'      => $result_small,
					'discount'          => to_decimal($get_row->purchase_order_detail_discount_percentage),
					'discount_total'    => number_format($get_row->purchase_order_detail_discount_total),
					'total'             => $total,
					'total_stock'       => $total_stock,
					'total_stock_stored'=> $total_stock,
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function save()
	{	
		$id             = $this->input->post('id');
		$trx_id         = $this->input->post('trx_id');
		$rtr_id         = $this->input->post('rtr_id');
		$number         = $this->input->post("number");
		$date           = $this->input->post("date");
		$supplier       = $this->input->post("supplier");
		// $payment_method = $this->input->post("payment_method");
		// $payment_term   = $this->input->post("payment_term");
		// $payment_due    = $this->input->post("payment_due");
		$grand_total    = $this->input->post("grand_total");
		$description    = $this->input->post("description");

		$tmstamp         = $this->input->post("tmstamp");
		
		$vuedata = $this->input->post('vuedata');

		// $payment_term_data = ($payment_term == "" ? "0" : substr($payment_term ,0 ,-5));
		// $payment_due_data  = ($payment_due == "" ? "0000-00-00" : change_format_date($payment_due));

		$header_id   = $rtr_id;
		$header_data = [
			'purchase_order_header_id'     		 => $id,
			'purchase_return_header_number'      => $number,
			'purchase_return_header_date'        => change_format_date($date),
			'purchase_return_header_supplier_id' => $supplier,
			'purchase_return_header_grand_total' => trims($grand_total),
			'purchase_return_header_description' => $description,
		];

		$detail_data = [];
		$log_data = [];

		// if save $id = new else update data
		if($trx_id == "new")
		{
			// save header
			$save_header = $this->Purchase_returns_model->save_header($header_data);
			if($save_header)
			{
				$header_id = $this->db->insert_id();
				foreach($vuedata as $row)
				{
					$detail_data[] = [
						'purchase_return_detail_header_id'            => $header_id,
						'purchase_return_detail_item_id'              => $row['id'],
						'purchase_return_detail_item_name'            => $row['name'],
						'purchase_return_detail_large_unit'           => $row['lg_unit'],
						'purchase_return_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
						'purchase_return_detail_large_unit_price'     => trims($row['lg_unit_prc']),
						'purchase_return_detail_result_large'         => trims($row['result_large']),
						'purchase_return_detail_medium_unit'          => $row['md_unit'],
						'purchase_return_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
						'purchase_return_detail_medium_unit_price'    => trims($row['md_unit_prc']),
						'purchase_return_detail_result_medium'        => trims($row['result_medium']),
						'purchase_return_detail_small_unit'           => $row['sm_unit'],
						'purchase_return_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
						'purchase_return_detail_small_unit_price'     => trims($row['sm_unit_prc']),
						'purchase_return_detail_result_small'         => trims($row['result_small']),
						'purchase_return_detail_total'                => trims($row['total'])
					];

					// $where                 = array('log_item_id' => $row['id']);
					$dtstamp = change_format_date($date). " " .date("H:i:s");
					$where   = array('log_item_id' => $row['id'], 'a.timestamp <' => $dtstamp);
					$log_data_check        = $this->Logs_model->get_data_last($where)->row_array();
					$last_total_stock      = 0;
					$last_log_total_stock_value = 0;
					// $last_log_avg_large = 0;

					if(!empty($log_data_check)){
						$last_total_stock           = $log_data_check['log_total_stock'];
						$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
						// $last_log_avg_large         = $log_data_check['log_average_large_unit'];
					}

					$medium_purchase_price = ($row['md_unit_cnt'] == 0 ? 0 : (trims($row['lg_unit_prc']) / $row['md_unit_cnt']));
					$small_purchase_price = ($row['sm_unit_cnt'] == 0 ? 0 : (trims($row['lg_unit_prc']) / $row['lg_unit_cnt']));

					$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * (- trims($row['lg_unit_qty']))) + ($row['md_unit_cnt'] * (- trims($row['md_unit_qty']))) + ($row['sm_unit_cnt'] * (- trims($row['sm_unit_qty'])));
					$log_total_transaction_value = ((- trims($row['lg_unit_qty'])) * trims($row['lg_unit_prc'])) + ((- trims($row['md_unit_qty'])) * $medium_purchase_price) + ((- trims($row['sm_unit_qty'])) * $small_purchase_price);
					$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
					$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
					// $log_average_small_unit      = ($log_total_stock_value / $log_total_stock);
					$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
					$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
					$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);

					$log_data[] = [
						'log_type'                            => 'R-BUY',
						'log_transaction_id'                  => $header_id,
						'log_item_id'                         => $row['id'],
						'log_large_unit'                      => $row['lg_unit'],
						'log_large_unit_contain'              => $row['lg_unit_cnt'],
						'log_large_unit_quantity'             => (- trims($row['lg_unit_qty'])),
						// 'log_large_unit_purchase_price'       => $last_log_avg_large,
						'log_large_unit_purchase_price'        => trims($row['lg_unit_prc']),
						'log_medium_unit'                     => $row['md_unit'],
						'log_medium_unit_contain'             => $row['md_unit_cnt'],
						'log_medium_unit_quantity'            => (- trims($row['md_unit_qty'])),
						// 'log_medium_unit_purchase_price'      => $medium_purchase_price,
						'log_medium_unit_purchase_price'       => trims($row['md_unit_prc']),
						'log_small_unit'                      => $row['sm_unit'],
						'log_small_unit_contain'              => $row['sm_unit_cnt'],
						'log_small_unit_quantity'             => (- trims($row['sm_unit_qty'])),
						// 'log_small_unit_purchase_price'       => $small_purchase_price,
						'log_small_unit_purchase_price'        => trims($row['sm_unit_prc']),
						'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
						'log_total_transaction_value'         => $log_total_transaction_value,
						'log_total_stock'                     => $log_total_stock,
						'log_total_stock_value'               => $log_total_stock_value,
						'log_average_large_unit'              => $log_average_large_unit,
						'log_average_medium_unit'             => $log_average_medium_unit,
						'log_average_small_unit'              => $log_average_small_unit,
						'timestamp'                           => $dtstamp
					];

				}
				
				$save_detail = $this->Purchase_returns_model->save_detail($detail_data, true);
				
				if($save_detail)
				{	
					$save_log = $this->Logs_model->save($log_data, true);

					if($save_log)
					{	
						$update_log = $this->update_log($vuedata, $header_id, $date);
									// $update_log = true;
								if($update_log)
								{	
									// $s_trx = 'update';
									// $update_master_item = $this->Purchase_orders_model->update_master_item_batch($newprice_data);
									// if($update_master_item)
									// {
										$msg    = "Berhasil menyimpan data";
										$status = "success";
									// }else{
									// 	$msg    = "Gagal menyimpan data #CKP-U01";
									// 	$status = "error";	
									// }
								}else{
									$msg    = "Gagal menyimpan data #CKP-U01";
									$status = "error";	
								}
					}
					else
					{
						$msg    = "Gagal menyimpan data";
						$status = "error";	
					}
				}
				else
				{
					$msg    = "Gagal menyimpan data";
					$status = "error";	
				}
			}
			else
			{
				$msg    = "Gagal menyimpan data";
				$status = "error";	
			}
			
		}else{
			
			// This New Update
			$delete_detail = $this->Purchase_returns_model->delete_detail($rtr_id);
	
			if ($delete_detail) {
				
				// $delete_log = $this->delete_log($id);
				$delete_log = $this->Logs_model->delete(array('log_transaction_id' => $rtr_id, 'log_type' => 'R-BUY'));

				if($delete_log){
					$save_header = $this->Purchase_returns_model->update_header($rtr_id, $header_data);

				if($save_header)
				{
					// $header_id = $this->db->insert_id();
					foreach($vuedata as $row)
					{
						$detail_data[] = [
							'purchase_return_detail_header_id'            => $header_id,
							'purchase_return_detail_item_id'              => $row['id'],
							'purchase_return_detail_item_name'            => $row['name'],
							'purchase_return_detail_large_unit'           => $row['lg_unit'],
							'purchase_return_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
							'purchase_return_detail_large_unit_price'     => trims($row['lg_unit_prc']),
							'purchase_return_detail_result_large'         => trims($row['result_large']),
							'purchase_return_detail_medium_unit'          => $row['md_unit'],
							'purchase_return_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
							'purchase_return_detail_medium_unit_price'    => trims($row['md_unit_prc']),
							'purchase_return_detail_result_medium'        => trims($row['result_medium']),
							'purchase_return_detail_small_unit'           => $row['sm_unit'],
							'purchase_return_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
							'purchase_return_detail_small_unit_price'     => trims($row['sm_unit_prc']),
							'purchase_return_detail_result_small'         => trims($row['result_small']),
							'purchase_return_detail_total'                => trims($row['total'])
						];
						
						// $where                 = array('log_item_id' => $row['id'], 'a.timestamp <' => $tmstamp);
						$dtstamp = change_format_date($date). " " .$tmstamp;
						$where   = array('log_item_id' => $row['id'], 'a.timestamp <' => $dtstamp);
						$log_data_check        = $this->Logs_model->get_data_last($where)->row_array();
						$last_total_stock      = 0;
						$last_log_total_stock_value = 0;
						$last_log_avg_large = 0;
						$last_log_avg_medium = 0;
						$last_log_avg_small = 0;

						if(!empty($log_data_check)){
							$last_total_stock           = $log_data_check['log_total_stock'];
							$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
							$last_log_avg_large         = $log_data_check['log_average_large_unit'];
							$last_log_avg_medium        = $log_data_check['log_average_medium_unit'];
							$last_log_avg_small         = $log_data_check['log_average_small_unit'];
						}

						$medium_purchase_price = ($row['md_unit_cnt'] == 0 ? 0 : ($last_log_avg_medium));
						$small_purchase_price  = ($row['sm_unit_cnt'] == 0 ? 0 : ($last_log_avg_small));

						$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * (- trims($row['lg_unit_qty']))) + ($row['md_unit_cnt'] * (- trims($row['md_unit_qty']))) + ($row['sm_unit_cnt'] * (- trims($row['sm_unit_qty'])));
						$log_total_transaction_value = ((- trims($row['lg_unit_qty'])) * $last_log_avg_large) + ((- trims($row['md_unit_qty'])) * $medium_purchase_price) + ((- trims($row['sm_unit_qty'])) * $small_purchase_price);
						$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
						$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
						$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
						$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
						$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);

						$log_data[] = [
							'log_type'                            => 'R-BUY',
							'log_transaction_id'                  => $header_id,
							'log_item_id'                         => $row['id'],
							'log_large_unit'                      => $row['lg_unit'],
							'log_large_unit_contain'              => $row['lg_unit_cnt'],
							'log_large_unit_quantity'             => (- trims($row['lg_unit_qty'])),
							// 'log_large_unit_purchase_price'       => $last_log_avg_large,
							'log_large_unit_purchase_price'        => trims($row['lg_unit_prc']),
							'log_medium_unit'                     => $row['md_unit'],
							'log_medium_unit_contain'             => $row['md_unit_cnt'],
							'log_medium_unit_quantity'            => (- trims($row['md_unit_qty'])),
							// 'log_medium_unit_purchase_price'      => $medium_purchase_price,
							'log_medium_unit_purchase_price'       => trims($row['md_unit_prc']),
							'log_small_unit'                      => $row['sm_unit'],
							'log_small_unit_contain'              => $row['sm_unit_cnt'],
							'log_small_unit_quantity'             => (- trims($row['sm_unit_qty'])),
							// 'log_small_unit_purchase_price'       => $small_purchase_price,
							'log_small_unit_purchase_price'        => trims($row['sm_unit_prc']),
							'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
							'log_total_transaction_value'         => $log_total_transaction_value,
							'log_total_stock'                     => $log_total_stock,
							'log_total_stock_value'               => $log_total_stock_value,
							'log_average_large_unit'              => $log_average_large_unit,
							'log_average_medium_unit'             => $log_average_medium_unit,
							'log_average_small_unit'              => $log_average_small_unit,
							'timestamp'                           => $dtstamp
						];
						
					}

					$save_detail = $this->Purchase_returns_model->save_detail($detail_data, true);

					if($save_detail)
					{

						$save_log = $this->Logs_model->save($log_data, true);

						if($save_log)
						{	
							$update_log = $this->update_log($vuedata, $header_id, $date);
							// $update_log = true;
							if($update_log)
							{	
								// $s_trx = 'update';
								// $checkpoint = $this->checkpoint($s_trx, $header_id, $date, $customer);
								// if($checkpoint)
								// {
									$msg    = "Berhasil menyimpan data";
									$status = "success";
								// }else{
								// 	$msg    = "Gagal menyimpan data #CKP-U01";
								// 	$status = "error";	
								// }
							}else{
								$msg    = "Gagal menyimpan data #CKP-U01";
								$status = "error";	
							}
						}
						else
						{
							$msg    = "Gagal menyimpan data #LOG-S01";
							$status = "error";	
						}
						
					}
					else
					{
						$msg    = "Gagal menyimpan data #LOG-U01";
						$status = "error";	
					}
				}
				else{
					$msg    = "Gagal menyimpan data #HED-U01";
					$status = "error";
				}
				}else{

				}

			}
			else{
				$msg    = "Gagal menyimpan data #DEL-U01";
				$status = "error";
			}

		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);

	}

	public function update_log($vuedata, $header_id, $date)
	{	
		$data_log = [];
		$data_where = [];

		$updateData = array();

		$total_stok = 0;
		$total_stok_rupiah = 0;
		$avg_lg = 0;
		$avg_md = 0;
		$avg_sm = 0;

		foreach($vuedata as $rowes)
		{
			
			$where_1         = array('log_item_id' => $rowes['id']);
			$get_first       = $this->Logs_model->get_data_first($where_1)->row();
			$logs_id         = $get_first->tmslog;

			$total_stok      = $get_first->log_total_stock;
			$total_stok_rupiah = $get_first->log_total_stock_value;

			$avg_lg  = ($get_first->log_average_large_unit);
			$avg_md  = ($get_first->log_average_medium_unit);
			$avg_sm  = ($get_first->log_average_small_unit);

			$log_total_transaction_value = 0;
		
			$where_2 = array('log_item_id' => $rowes['id'], 'a.timestamp >' => $logs_id);
			$get_data_all_logs_by_item = $this->Logs_model->get_data($where_2, 'a.timestamp asc')->result();

			foreach ($get_data_all_logs_by_item as $row) {


				$total_stok      += $row->log_total_transaction_in_small_unit;
				
				if($row->log_type == "BUY" || $row->log_type == "R-SELL"){
					$log_total_transaction_value = (($row->log_large_unit_quantity * ($row->log_large_unit_purchase_price)) + ($row->log_medium_unit_quantity * ($row->log_medium_unit_purchase_price)) + ($row->log_small_unit_quantity * ($row->log_medium_unit_purchase_price)));
				}else{
					$log_total_transaction_value = (($row->log_large_unit_quantity * ($avg_lg)) + ($row->log_medium_unit_quantity * ($avg_md)) + ($row->log_small_unit_quantity * ($avg_sm)));
				}
				$total_stok_rupiah += $log_total_transaction_value;
				

				$log_average_small_unit  = ($total_stok == 0 ? 0 : ($total_stok_rupiah / $total_stok));
				$log_average_medium_unit = ($log_average_small_unit * $row->medium_unit_contain);
				$log_average_large_unit  = ($log_average_small_unit * $row->large_unit_contain);

				// $log_total_transaction_value = a;

				if($row->log_type == "BUY" || $row->log_type == "R-SELL"){
					$avg_lg  = ($log_average_large_unit);
					$avg_md  = ($log_average_medium_unit);
					$avg_sm  = ($log_average_small_unit);
					$data_log[] = array(
						'log_id'                        => $row->log_id,
						// 'log_medium_unit_purchase_price' => $medium_purchase_price,
						// 'log_small_unit_purchase_price'  => $small_purchase_price,
						// 'log_total_transaction_value' => $log_total_transaction_value,
						'log_total_stock'             => $total_stok,
						'log_total_stock_value'       => $total_stok_rupiah,
						'log_average_large_unit'      => $log_average_large_unit,
						'log_average_medium_unit'     => $log_average_medium_unit,
						'log_average_small_unit'      => $log_average_small_unit,
						// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
					);
				}else{

					$data_log[] = array(
						'log_id'                         => $row->log_id,
						'log_large_unit_purchase_price'  => $avg_lg,
						'log_medium_unit_purchase_price' => $avg_md,
						'log_small_unit_purchase_price'  => $avg_sm,
						'log_total_transaction_value'    => $log_total_transaction_value,
						'log_total_stock'                => $total_stok,
						'log_total_stock_value'          => $total_stok_rupiah,
						'log_average_large_unit'         => $log_average_large_unit,
						'log_average_medium_unit'        => $log_average_medium_unit,
						'log_average_small_unit'         => $log_average_small_unit,
						// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
					);
				}
				

				
			}
			
			
		}

		$after_row_log_update = $this->Logs_model->update_item_batch($data_log);

		return true;
	}

	public function delete()
	{
		$id = $this->input->post('id');
		$data_log = [];
		foreach($id as $row)
		{	
			$where = array('log_type' => 'R-BUY', 'log_transaction_id' => $row);
			$get_data_log = $this->Logs_model->get_data($where)->result();

			foreach ($get_data_log as $row_list) {

				// Get Data After This Item ID :::
				$where_after = array('log_item_id' => $row_list->log_item_id, 'log_id >' => $row_list->log_id);
				$get_after_data = $this->Logs_model->get_data($where_after)->result();

				if($get_after_data){
					foreach ($get_after_data as $row_list_detail) {
					
						$where_log_delete = array(
							'log_item_id' => $row_list->log_item_id, 
							'log_id' => $row_list->log_id
						);

						$delete_logs = $this->Logs_model->delete($where_log_delete);
						
						$where_this = array('log_id' => $row_list_detail->log_id, 'log_item_id' => $row_list_detail->log_item_id);
						$log_id = $this->Logs_model->get_data($where_this)->row()->log_id;

						// $where_this = array('log_type' => 'R-BUY', 'log_transaction_id' => $row_list_detail->log_transaction_id, 'log_item_id' => $row_list_detail->log_item_id);
						// $log_id = $this->Logs_model->get_data($where_this)->row()->log_id;
						
						$where_3 = array('log_item_id' => $row_list_detail->log_item_id, 'log_id <' => $log_id);
						$one_line_before_log_data  = $this->Logs_model->get_data_last($where_3)->row_array();
						$one_line_before_total     = 0;
						$one_line_before_log_total = 0;
						$one_line_before_log_avg_large = 0;

						if(!empty($one_line_before_log_data)){
							$one_line_before_total     = $one_line_before_log_data['log_total_stock'];
							$one_line_before_log_total = $one_line_before_log_data['log_total_stock_value'];
							$one_line_before_log_avg_large = $one_line_before_log_data['log_average_large_unit'];
						}

						$log_total_stock	     = ($one_line_before_total + $row_list_detail->log_total_transaction_in_small_unit);
						$log_total_stock_value   = ($one_line_before_log_total + $row_list_detail->log_total_transaction_value);
						// $log_average_small_unit  = ($log_total_stock_value / $log_total_stock);
						$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
						$log_average_medium_unit = ($log_average_small_unit * $row_list_detail->medium_unit_contain);
						$log_average_large_unit  = ($log_average_small_unit * $row_list_detail->large_unit_contain);

						$after_row_data_update = array(
							'log_id'                  => $row_list_detail->log_id,
							'log_total_stock'         => $log_total_stock,
							'log_total_stock_value'   => $log_total_stock_value,
							'log_average_large_unit'  => $log_average_large_unit,
							'log_average_medium_unit' => $log_average_medium_unit,
							'log_average_small_unit'  => $log_average_small_unit
						);

						$after_row_where_update = array(
							'log_id' => $row_list_detail->log_id,
						);

						$after_row_log_update = $this->Logs_model->update_item($after_row_where_update, $after_row_data_update);
					}
				}else{
					$where_log_delete = array(
						'log_item_id' => $row_list->log_item_id, 
						'log_id' => $row_list->log_id
					);

					$delete_logs = $this->Logs_model->delete($where_log_delete);
				}
			}

			$delete_header = $this->Purchase_returns_model->delete_header($row);

			if($delete_header){
				$delete_type = $this->Purchase_returns_model->delete_detail($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out($id)
	{	
		$where_header = array('sales_order_header_id' => $id);
		$where_detail = array('sales_order_detail_header_id' => $id);

		$header = $this->Purchase_returns_model->salesorder_header($where_header)->row_array();
		$detail = $this->Purchase_returns_model->salesorder_detail($where_detail)->result();

		$data['content_title'] = 'Print Penjualan';
		$data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/sales_orders/print_out', $data);
	}


}

?>
