/**
 * Javascript Point Requirements
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.MASTER = (function ($) {

	var renderCheckbox = function (data, type, full, meta) {
		return '<input class="check-sub-master" type="checkbox" value="' + full['id'] + '">';
	}

	var renderEdit = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/journals/edit/' + full['id'];
		return '<a class="master-edit" href="' + url + '" data-toggle="tooltip" data-placement="right" title="Tekan untuk Edit">' + data + '</a>';
	}

	var renderPrint = function(data, type, full, meta) {
    	var url = APP.siteUrl + 'adm/journals/print_out/' + full['id'];
        return '<a class="master-edit" href="' + url + '" data-toggle="tooltip" data-placement="right" title="Tekan untuk Print"><i class="fa fa-print btn btn-success btn-sm"></i></a>';
    }

	return {

		elDatatable: null,
		elDatatablePO: null,
		elDatatableSO: null,
		elDatatablePB: null,
		elDatatableST: null,
		elDatatableKAS: null,

		elVue: '#vue-master',
		elForm: '.master-form',
		elEdit: '.master-edit',

		elTable: '#master-table',
		elTablePO: '#master-tablepo',
		elTableSO: '#master-tableso',
		elTablePB: '#master-tablepb',
		elTableST: '#master-tablest',
		elTableKAS: '#master-tablekas',

		elBtnDelete: '.master-delete',
		elSubCheckbox: '.check-sub-master',
		elParentCheckbox: '.check-all-master',
		urlDeleteData: window.APP.siteUrl + 'adm/journals/delete',

		urlRequestData: window.APP.siteUrl + 'adm/journals/get_data_header',
		urlRequestDataPO: window.APP.siteUrl + 'adm/journals/get_data_header_po',
		urlRequestDataSO: window.APP.siteUrl + 'adm/journals/get_data_header_so',
		urlRequestDataPB: window.APP.siteUrl + 'adm/journals/get_data_header_pb',
		urlRequestDataST: window.APP.siteUrl + 'adm/journals/get_data_header_st',
		urlRequestDataKAS: window.APP.siteUrl + 'adm/journals/get_data_header_kas',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var parentThis = this;
		},

		// Master
		handleVueMaster: function () {
			var parentThis = this;

			// Vue Js
			new Vue({
				el: parentThis.elVue,
				delimiters: ['<%', '%>'],
				methods: {
					addRowType: function () {
						var vue = this;
					},

				},
				mounted: function () {
					
					parentThis.handleDataTable();
					parentThis.handleDataTablePO();
					parentThis.handleDataTableSO();
					parentThis.handleDataTablePB();
					parentThis.handleDataTableST();
					parentThis.handleDataTableKAS();

					$('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
						$.fn.dataTable.tables({ visible: true, api: true }).columns.adjust();
					});
				}
			});

		},

		handleCheckbox: function () {
			var parentThis = this;

			$(parentThis.elTable).on("click", parentThis.elSubCheckbox, function () {
				var row     = ($('#master-table tr').length - 1);
				var checked = $('#master-table').find('input[class="check-sub-master"]:checked');

				if(row == checked.length){
					$('#check-all-master').prop('checked', true);
				}else{
					$('#check-all-master').prop('checked', false);
				}

			});

			$('select[name="master-table_length"]').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
				
			});

			$('#master-table_paginate').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
			});

		},

		// Point Requirements : handleDataTable
		handleDataTable: function () {
			var parentThis = this;

			// Datatable
			// $('#master-table thead tr:eq(6) th:eq(7)').html("This is a really long column title!");

			parentThis.elDatatable = $(parentThis.elTable).DataTable({
				ajax: {
					url: parentThis.urlRequestData
				},
				columns: [
					{
						data: 'no',
						width: '20',
						className: 'fit-width',
						render: renderCheckbox
					},
					{
						data: 'number',
						render: renderEdit
					},
					{
						data: 'date',
					},
					{
						data: 'description',
					},
					{
						className: 'fit-width',
						render: renderPrint
					},
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0,4],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {
					parentThis.handleDelete();
					parentThis.handleCheckbox();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
				}

			});
		},

		handleDataTablePO: function () {
			var parentThis = this;

			// Datatable
			// $('#master-table thead tr:eq(6) th:eq(7)').html("This is a really long column title!");

			parentThis.elDatatablePO = $(parentThis.elTablePO).DataTable({
				ajax: {
					url: parentThis.urlRequestDataPO
				},
				columns: [
					{
						data: 'no',
						width: '20',
						className: 'fit-width',
						render: renderCheckbox
					},
					{
						data: 'number',
						render: renderEdit
					},
					{
						data: 'date',
					},
					{
						data: 'description',
					},
					{
						className: 'fit-width',
						render: renderPrint
					},
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0,4],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {
					parentThis.handleDelete();
					parentThis.handleCheckbox();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
				}

			});
		},

		handleDataTableSO: function () {
			var parentThis = this;

			// Datatable
			// $('#master-table thead tr:eq(6) th:eq(7)').html("This is a really long column title!");

			parentThis.elDatatableSO = $(parentThis.elTableSO).DataTable({
				ajax: {
					url: parentThis.urlRequestDataSO
				},
				columns: [
					{
						data: 'no',
						width: '20',
						className: 'fit-width',
						render: renderCheckbox
					},
					{
						data: 'number',
						render: renderEdit
					},
					{
						data: 'date',
					},
					{
						data: 'description',
					},
					{
						className: 'fit-width',
						render: renderPrint
					},
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0,4],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {
					parentThis.handleDelete();
					parentThis.handleCheckbox();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
				}

			});
		},

		handleDataTablePB: function () {
			var parentThis = this;

			// Datatable
			// $('#master-table thead tr:eq(6) th:eq(7)').html("This is a really long column title!");

			parentThis.elDatatablePB = $(parentThis.elTablePB).DataTable({
				ajax: {
					url: parentThis.urlRequestDataPB
				},
				columns: [
					{
						data: 'no',
						width: '20',
						className: 'fit-width',
						render: renderCheckbox
					},
					{
						data: 'number',
						render: renderEdit
					},
					{
						data: 'date',
					},
					{
						data: 'description',
					},
					{
						className: 'fit-width',
						render: renderPrint
					},
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0,4],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {
					parentThis.handleDelete();
					parentThis.handleCheckbox();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
				}

			});
		},

		handleDataTableST: function () {
			var parentThis = this;

			// Datatable
			// $('#master-table thead tr:eq(6) th:eq(7)').html("This is a really long column title!");

			parentThis.elDatatableST = $(parentThis.elTableST).DataTable({
				ajax: {
					url: parentThis.urlRequestDataST
				},
				columns: [
					{
						data: 'no',
						width: '20',
						className: 'fit-width',
						render: renderCheckbox
					},
					{
						data: 'number',
						render: renderEdit
					},
					{
						data: 'date',
					},
					{
						data: 'description',
					},
					{
						className: 'fit-width',
						render: renderPrint
					},
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0,4],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {
					parentThis.handleDelete();
					parentThis.handleCheckbox();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
				}

			});
		},
		handleDataTableKAS: function () {
			var parentThis = this;

			// Datatable
			// $('#master-table thead tr:eq(6) th:eq(7)').html("This is a really long column title!");

			parentThis.elDatatableKAS = $(parentThis.elTableKAS).DataTable({
				ajax: {
					url: parentThis.urlRequestDataKAS
				},
				columns: [
					{
						data: 'no',
						width: '20',
						className: 'fit-width',
						render: renderCheckbox
					},
					{
						data: 'number',
						render: renderEdit
					},
					{
						data: 'date',
					},
					{
						data: 'description',
					},
					{
						className: 'fit-width',
						render: renderPrint
					},
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0,4],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {
					parentThis.handleDelete();
					parentThis.handleCheckbox();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
				}

			});
		},

		// Point Requirements : handleDelete
		handleDelete: function () {
			var parentThis = this;

			$(parentThis.elBtnDelete).click(function () {

				var Items = $(parentThis.elTable).find('input[class="check-sub-master"]:checked');

				var types = [];
				for (var i = 0; i < Items.length; i++) {
					types.push($(Items[i]).val());
				}

				if (!types.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin menghapus data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Hapus!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
							$.ajax({
								type: "POST",
								dataType: 'json',
								url: parentThis.urlDeleteData,
								data: {
									id: types,
								},
								success: function (response) {
									window.FORM.showNotification(response.message, response.status);
									parentThis.elDatatable.ajax.reload();

									$('input[type="checkbox"]').prop('checked', false);
								}
							});
						}
					})


				}
			});
		},

	}

})(jQuery);