/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elCustomer: '.select-customer',
		elDate: '.date-log',

		urlRequestData: window.APP.siteUrl + 'adm/report_points/get_data_detail',
		urlRequestDataTotal: window.APP.siteUrl + 'adm/report_points/get_data_detail_total',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					customer_name: '',
					total:1,
					ttl:0,
					date_log: '',
					detailData: []
				},
				methods: {
					getData: function () {
						var vue = this;
						var val_customer = $(that.elCustomer).val();
						var val_date     = $(that.elDate).val();

						var text_customer  = $(that.elCustomer + ' option:selected').text();

						vue.$set(vue, 'customer_name', text_customer);
						vue.$set(vue, 'date_log', val_date);

						if (val_customer == "") {
							$.ajax({
								url: that.urlRequestDataTotal,
								type: 'post',
								data: {
									'customer': val_customer,
									'date_log': val_date
								},
								dataType: "json",
								beforeSend : function() {
									$(that.elVue).block({
										message: '<h4>Please Wait..</h4>'
									});
								},
								success: function (response) {
									vue.$set(vue, 'detailData', response['data']);
									vue.$set(vue, 'ttl', response['ttl']);
									vue.$set(vue, 'total', 1);
									$(that.elVue).unblock();
								}
							});
						} else {
							$.ajax({
								url: that.urlRequestData,
								type: 'post',
								data: {
									'customer': val_customer,
									'date_log': val_date
								},
								dataType: "json",
								beforeSend : function() {
									$(that.elVue).block({
										message: '<h4>Please Wait..</h4>'
									});
								},
								success: function (response) {
									vue.$set(vue, 'detailData', response);
									vue.$set(vue, 'total', 0);
									vue.$set(vue, 'date_log', 0);
									$(that.elVue).unblock();
								}
							});
						}
					},

					exportExcel: function () {
						var vue = this;

						var val_customer = $(that.elCustomer).val();
						if (val_customer == "") {
							vue.getData();

							setTimeout(function () {
								window.location = window.APP.siteUrl + 'adm/report_points/export_excel_total';
							}, 500);
						} else {
							vue.getData();

							setTimeout(function () {
								window.location = window.APP.siteUrl + 'adm/report_points/export_excel';
							}, 500);
						}
					}
				},
				mounted: function () {

				}
			});

		},

	}

})(jQuery);