<?php
/**
 * Special Prices Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Special_prices extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Special_prices_model');
		$this->load->model('Customers_model');
		$this->load->model('Items_model');
	}

 	public function edit($id)
	{
		$title       = "Harga Pelanggan";
		$where       = array('customer_id' => $id);
		$header_data = $this->Customers_model->get_data($where)->row_array();
		
		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		
		$this->twiggy_display('adm/special_prices/edit', $data);
	}

	public function get_data_detail()
	{	
		$id = $this->input->post("id");
		$where       = array('a.customer_id' => $id);
		$order       = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Special_prices_model->get_data($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{

				$data[] = array(
					'no'     => $no,
					'id'     => $get_row->item_id,
					'name'   => $get_row->item_name,
					'unit'   => $get_row->large_unit,
					'price'  => number_format($get_row->price),
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Barang';
		$this->twiggy_display('adm/special_prices/embed', $data);
	}

	public function get_data_embed()
	{
		$data = [];
		$response = [];
		$search   = $this->input->post('search');

		$get_data  = $this->Items_model->get_data_search($search)->result();

		$no = 0;
		foreach($get_data as $get_row)
		{	
			$data[] = array(
					'no'             => $no,
					'id'             => $get_row->item_id,
					'name'           => $get_row->item_name,
					'group_id'       => $get_row->group_id,
					'group_name'     => $get_row->group_name,
					'group_child_id' => $get_row->group_child_id,
					'group_child_name' => $get_row->group_child_name,
					'lg_unit'        => $get_row->large_unit,
					'lg_unit_qty'    => $get_row->large_unit_contain,
					'lg_unit_prc'    => number_format($get_row->last_selling_price_large_unit),
					'md_unit'        => $get_row->medium_unit,
					'md_unit_qty'    => $get_row->medium_unit_contain,
					'md_unit_prc'    => number_format($get_row->last_selling_price_medium_unit),
					'sm_unit'        => $get_row->small_unit,
					'sm_unit_qty'    => $get_row->small_unit_contain,
					'sm_unit_prc'    => number_format($get_row->last_selling_price_small_unit),
					'btncolor' => '',
					'btnicon'  => '',
			);

			$no++;
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

		output_json($response);
		
	}

	public function save()
	{	
		$id       = $this->input->post('id');
		$vuedata  = $this->input->post('vuedata');
		
		$where    = array('a.customer_id' => $id);
		$get_data = $this->Special_prices_model->get_data($where)->result();
		$detail_data = [];

		if($vuedata == null){
			$delete_detail = $this->Special_prices_model->delete($id);
			if($delete_detail)
			{
				$msg    = "Berhasil menyimpan data";
				$status = "success";
			}
			else
			{
				$msg    = "Gagal menyimpan data";
				$status = "error";	
			}
		}else{
			if(count($get_data) > 0){
				$delete_detail = $this->Special_prices_model->delete($id);
			}

			foreach($vuedata as $row)
			{
				$detail_data[] = [
					'customer_id'  => $id,
					'item_id'      => $row['id'],
					'large_unit'   => $row['unit'],
					'price'        => trims($row['price']),
					'is_active'    => '1',
				];
			}

			$save_detail = $this->Special_prices_model->save($detail_data, true);
			
			if($save_detail)
			{
				$msg    = "Berhasil menyimpan data";
				$status = "success";
			}
			else
			{
				$msg    = "Gagal menyimpan data";
				$status = "error";	
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $id
		];
		output_json($response);
	}

}

?>
