/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elDate_1: '.date_1',
		elDate_2: '.date_2',
		elStatus: '.select_ppn',

		urlRequestData: window.APP.siteUrl + 'adm/Report_neraca/get_data_detail',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					elDate_1: '',
					elDate_2: '',
					elStatus: '',
					date_1: '',
					date_2: '',
					status: '',
					totalAktiva: 0,
					totalLiabilities: 0,
					totalEquitas:0,
					detailDataAktiva: [],
					detailDataLiabilities: [],
				},
				methods: {
					getData: function () {
						var vue = this;

						var val_date_1 = $(that.elDate_1).val();
						var val_date_2 = $(that.elDate_2).val();
				// 		var val_status = $(that.elStatus).val();

						// console.log("ADS");
						$.ajax({
							url: that.urlRequestData,
							type: 'post',
							data: {
								'date_1': val_date_1,
								'date_2': val_date_2,
								// 'status': val_status
							},
							dataType: "json",
							beforeSend : function() {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
							success: function (response) {
								vue.$set(vue, 'detailDataAktiva', response['dataAktiva']);
                                vue.$set(vue, 'detailDataLiabilities', response['dataLiabilites']);
								vue.$set(vue, 'totalAktiva', response['total_aktiva']);
								vue.$set(vue, 'totalLiabilities', response['total_liabilities']);
								vue.$set(vue,'totalEquitas',response['total_laba_sebelum_pajak']);
								vue.$set(vue, 'date_1', val_date_1);
								vue.$set(vue, 'date_2', val_date_2);

								$(that.elVue).unblock();
							}
						});
					},

					exportExcel: function () {
						var vue = this;
						vue.getData();

						setTimeout(function () {
							window.location = window.APP.siteUrl + 'adm/report_profits_bydate/export_excel';
						}, 500);
					}
				},
				mounted: function () {

				}
			});

		},

	}

})(jQuery);