<?php
/**
 * Report Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Reports_model extends Model {

	public function get_special_price($select='*', $where='', $order='', $group='')
	{
		$sql = $this->db;

		$sql->select($select);
	    $sql->from('master_special_prices a');
	    $sql->join('master_customers b', 'b.customer_id = a.customer_id', 'inner');
	    $sql->join('master_items c', 'c.item_id = a.item_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_poheader($select='*', $where='', $order='', $group='')
	{
    	$sql = $this->db;

		$sql->select($select);
		$sql->from('purchase_order_headers a');
	    $sql->join('master_suppliers b', 'b.supplier_id = a.purchase_order_header_supplier_id', 'inner');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_soheader($select='*', $where='', $order='', $group='')
	{
    	$sql = $this->db;

		$sql->select($select);
		$sql->from('sales_order_headers a');
	    $sql->join('master_customers b', 'b.customer_id = a.sales_order_header_customer_id', 'inner');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_profitByDate($date1, $date2, $status)
	{
		if($status != ""){
			$sql = "
			SELECT
				b.printed_date as sales_date,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_selling_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_selling_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_selling_price)) as total,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_purchase_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_purchase_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_purchase_price)) as total_cap
			FROM logs a
			INNER JOIN sales_order_headers b 
			ON a.log_transaction_id = b.sales_order_header_id AND a.log_type = 'SELL'
			INNER JOIN sales_order_details c
			ON a.log_transaction_id = c.sales_order_detail_header_id AND a.log_item_id = c.sales_order_detail_item_id AND a.log_type = 'SELL'
			WHERE b.printed_date BETWEEN '".$date1."' AND '".$date2."'
			AND c.sales_order_detail_ppn_status = '".$status."'
			AND b.is_hold = '0'
			GROUP BY b.printed_date;
			";
		}else{
			$sql = "
			SELECT
				b.printed_date as sales_date,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_selling_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_selling_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_selling_price)) as total,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_purchase_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_purchase_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_purchase_price)) as total_cap
			FROM logs a
			INNER JOIN sales_order_headers b 
			ON a.log_transaction_id = b.sales_order_header_id AND a.log_type = 'SELL'
			INNER JOIN sales_order_details c
			ON a.log_transaction_id = c.sales_order_detail_header_id AND a.log_item_id = c.sales_order_detail_item_id AND a.log_type = 'SELL'
			WHERE b.printed_date BETWEEN '".$date1."' AND '".$date2."'
			AND b.is_hold = '0'
			GROUP BY b.printed_date;
			";
		}

		return $this->db->query($sql);
	}
	
	public function get_laba_rugi_penjualan($date1, $date2, $status)
	{
		if($status != ""){
			$sql = "
			SELECT
				b.printed_date as sales_date,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_selling_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_selling_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_selling_price)) as total,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_purchase_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_purchase_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_purchase_price)) as total_cap,
			FROM logs a
			INNER JOIN sales_order_headers b 
			ON a.log_transaction_id = b.sales_order_header_id AND a.log_type = 'SELL'
			INNER JOIN sales_order_details c
			ON a.log_transaction_id = c.sales_order_detail_header_id AND a.log_item_id = c.sales_order_detail_item_id AND a.log_type = 'SELL'
			WHERE b.printed_date BETWEEN '".$date1."' AND '".$date2."'
			AND c.sales_order_detail_ppn_status = '".$status."'
			AND b.is_hold = '0'
			GROUP BY b.printed_date;
			";
		}else{
			$sql = "
			SELECT
				b.printed_date as sales_date,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_selling_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_selling_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_selling_price)) as total,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_purchase_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_purchase_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_purchase_price)) as total_cap
			FROM logs a
			INNER JOIN sales_order_headers b 
			ON a.log_transaction_id = b.sales_order_header_id AND a.log_type = 'SELL'
			INNER JOIN sales_order_details c
			ON a.log_transaction_id = c.sales_order_detail_header_id AND a.log_item_id = c.sales_order_detail_item_id AND a.log_type = 'SELL'
			WHERE b.printed_date BETWEEN '".$date1."' AND '".$date2."'
			AND b.is_hold = '0'
			GROUP BY b.printed_date;
			";
		}

		return $this->db->query($sql);
	}
	
	public function get_laba_rugi_retur_penjualan($date1, $date2,$status)
	{
		if($status != ""){
			$sql = "
			SELECT
				b.sales_return_header_date as sales_date,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_purchase_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_purchase_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_purchase_price)) as total,
			FROM logs a
			INNER JOIN sales_return_headers b 
			ON a.log_transaction_id = b.sales_return_header_id AND a.log_type = 'R-SELL'
			INNER JOIN sales_return_details c
			ON a.log_transaction_id = c.sales_return_detail_header_id AND a.log_item_id = c.sales_return_detail_item_id AND a.log_type = 'R-SELL'
			WHERE b.sales_return_header_date BETWEEN '".$date1."' AND '".$date2."'
			GROUP BY b.sales_return_header_date;
			";
		}else{
			$sql = "
			SELECT
				b.sales_return_header_date as sales_date,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_purchase_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_purchase_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_purchase_price)) as total
			FROM logs a
			INNER JOIN sales_return_headers b 
			ON a.log_transaction_id = b.sales_return_header_id AND a.log_type = 'R-SELL'
			INNER JOIN sales_return_details c
			ON a.log_transaction_id = c.sales_return_detail_header_id AND a.log_item_id = c.sales_return_detail_item_id AND a.log_type = 'R-SELL'
			WHERE b.sales_return_header_date BETWEEN '".$date1."' AND '".$date2."'
			GROUP BY b.sales_return_header_date;
			";
		}

		return $this->db->query($sql);
	}
	public function get_laba_rugi_retur_pembelian($date1, $date2,$status)
	{
		if($status != ""){
			$sql = "
			SELECT
				b.purchase_return_header_date as sales_date,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_purchase_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_purchase_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_purchase_price)) as total,
			FROM logs a
			INNER JOIN purchase_return_headers b 
			ON a.log_transaction_id = b.purchase_return_header_id AND a.log_type = 'R-BUY'
			INNER JOIN purchase_return_details c
			ON a.log_transaction_id = c.purchase_return_detail_header_id AND a.log_item_id = c.purchase_return_detail_item_id AND a.log_type = 'R-BUY'
			WHERE b.purchase_return_header_date BETWEEN '".$date1."' AND '".$date2."'
			GROUP BY b.purchase_return_header_date;
			";
		}else{
			$sql = "
			SELECT
				b.purchase_return_header_date as sales_date,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_purchase_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_purchase_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_purchase_price)) as total
			FROM logs a
			INNER JOIN purchase_return_headers b 
			ON a.log_transaction_id = b.purchase_return_header_id AND a.log_type = 'R-BUY'
			INNER JOIN purchase_return_details c
			ON a.log_transaction_id = c.purchase_return_detail_header_id AND a.log_item_id = c.purchase_return_detail_item_id AND a.log_type = 'R-BUY'
			WHERE b.purchase_return_header_date BETWEEN '".$date1."' AND '".$date2."'
			GROUP BY b.purchase_return_header_date;
			";
		}

		return $this->db->query($sql);
	}
	public function get_data_all_account_debet($date1, $date2)
	{
			$sql = "
			SELECT
				a.journal_header_date as sales_date,
				(SUM(b.journal_detail_debit) -
					SUM(b.journal_detail_credit)) as total,
					b.journal_detail_account_name as nama_akun
			FROM journal_headers a
			INNER JOIN journal_details b 
			ON a.journal_header_id  = b.journal_detail_header_id
			LEFT JOIN master_accounts c
			ON b.journal_detail_account_id  = c.account_id
			WHERE a.journal_header_date BETWEEN '".$date1."' AND '".$date2."'
			AND c.normal_balance = 'DEBET'
			GROUP BY b.journal_detail_account_id;
			";

		return $this->db->query($sql);
	}
	public function get_data_all_account_kredit($date1, $date2)
	{
			$sql = "
			SELECT
				a.journal_header_date as sales_date,
				(SUM(b.journal_detail_debit) -
					SUM(b.journal_detail_credit)) as total,
					b.journal_detail_account_name as nama_akun
			FROM journal_headers a
			INNER JOIN journal_details b 
			ON a.journal_header_id  = b.journal_detail_header_id
			LEFT JOIN master_accounts c
			ON b.journal_detail_account_id  = c.account_id
			WHERE a.journal_header_date BETWEEN '".$date1."' AND '".$date2."'
			AND c.normal_balance = 'KREDIT'
			GROUP BY b.journal_detail_account_id;
			";

		return $this->db->query($sql);
	}
	public function get_laba_rugi_hpp($date1, $date2)
	{
			$sql = "
			SELECT
				a.journal_header_date as sales_date,
				(SUM(b.journal_detail_debit) -
					SUM(b.journal_detail_credit)) as total,
					b.journal_detail_account_name as nama_akun
			FROM journal_headers a
			INNER JOIN journal_details b 
			ON a.journal_header_id  = b.journal_detail_header_id
			WHERE a.journal_header_date BETWEEN '".$date1."' AND '".$date2."'
			AND b.journal_detail_account_name = 'HPP'
			GROUP BY b.journal_detail_account_id;
			";

		return $this->db->query($sql);
	}
	public function get_laba_rugi_expense($date1, $date2)
	{
			$sql = "
			SELECT
				a.journal_header_date as sales_date,
				(SUM(b.journal_detail_debit) +
					SUM(b.journal_detail_credit)) as total,
					b.journal_detail_account_name as nama_akun
			FROM journal_headers a
			INNER JOIN journal_details b 
			ON a.journal_header_id  = b.journal_detail_header_id
			WHERE a.journal_header_date BETWEEN '".$date1."' AND '".$date2."'
			AND b.journal_detail_account_group = 'EXPENSE' AND b.journal_detail_account_name != 'HPP'
			GROUP BY b.journal_detail_account_id;
			";

		return $this->db->query($sql);
	}
	public function get_laba_rugi_gain($date1, $date2)
	{
			$sql = "
			SELECT
				a.journal_header_date as sales_date,
				(SUM(b.journal_detail_debit) +
					SUM(b.journal_detail_credit)) as total,
					b.journal_detail_account_name as nama_akun
			FROM journal_headers a
			INNER JOIN journal_details b 
			ON a.journal_header_id  = b.journal_detail_header_id
			WHERE a.journal_header_date BETWEEN '".$date1."' AND '".$date2."'
			AND b.journal_detail_account_group = 'GAIN'
			GROUP BY b.journal_detail_account_id;
			";

		return $this->db->query($sql);
	}
	public function get_data_aktiva($date1, $date2)
	{
			$sql = "
			SELECT
				a.journal_header_date as sales_date,
				(SUM(b.journal_detail_debit) -
					SUM(b.journal_detail_credit)) as total,
					b.journal_detail_account_name as nama_akun
			FROM journal_headers a
			INNER JOIN journal_details b 
			ON a.journal_header_id  = b.journal_detail_header_id
			WHERE a.journal_header_date BETWEEN '".$date1."' AND '".$date2."'
			AND b.journal_detail_account_group = 'ASSET'
			GROUP BY b.journal_detail_account_id;
			";

		return $this->db->query($sql);
	}
	public function get_data_liabilities($date1, $date2)
	{
			$sql = "
			SELECT
				a.journal_header_date as sales_date,
				(SUM(b.journal_detail_debit) -
					SUM(b.journal_detail_credit)) as total,
					b.journal_detail_account_name as nama_akun
			FROM journal_headers a
			INNER JOIN journal_details b 
			ON a.journal_header_id  = b.journal_detail_header_id
			WHERE a.journal_header_date BETWEEN '".$date1."' AND '".$date2."'
			AND b.journal_detail_account_group = 'LIABILITIES'
			GROUP BY b.journal_detail_account_id;
			";

		return $this->db->query($sql);
	}

	public function get_profitByItem($date1, $date2, $status)
	{
		if($status != ""){
			$sql = "
			SELECT
				b.printed_date as sales_date,
				c.sales_order_detail_item_id,
				c.sales_order_detail_item_name,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_selling_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_selling_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_selling_price)) as total,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_purchase_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_purchase_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_purchase_price)) as total_cap
			FROM logs a
			INNER JOIN sales_order_headers b 
			ON a.log_transaction_id = b.sales_order_header_id AND a.log_type = 'SELL'
			INNER JOIN sales_order_details c
			ON a.log_transaction_id = c.sales_order_detail_header_id AND a.log_item_id = c.sales_order_detail_item_id AND a.log_type = 'SELL'
			WHERE b.printed_date BETWEEN '".$date1."' AND '".$date2."'
			AND c.sales_order_detail_ppn_status = '".$status."'
			AND b.is_hold = '0'
			GROUP BY b.printed_date, c.sales_order_detail_item_id;
			";
		}else{
			$sql = "
			SELECT
				b.printed_date as sales_date,
				c.sales_order_detail_item_id,
				c.sales_order_detail_item_name,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_selling_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_selling_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_selling_price)) as total,
				SUM((ABS(a.log_large_unit_quantity) * a.log_large_unit_purchase_price) +
					(ABS(a.log_medium_unit_quantity) * a.log_medium_unit_purchase_price) +
					(ABS(a.log_small_unit_quantity) * a.log_small_unit_purchase_price)) as total_cap
			FROM logs a
			INNER JOIN sales_order_headers b 
			ON a.log_transaction_id = b.sales_order_header_id AND a.log_type = 'SELL'
			INNER JOIN sales_order_details c
			ON a.log_transaction_id = c.sales_order_detail_header_id AND a.log_item_id = c.sales_order_detail_item_id AND a.log_type = 'SELL'
			WHERE b.printed_date BETWEEN '".$date1."' AND '".$date2."'
			AND b.is_hold = '0'
			GROUP BY b.printed_date, c.sales_order_detail_item_id;
			";
		}

		return $this->db->query($sql);
	}

}

?>
