<?php
/**
 * API Group Group Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Group extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
        parent::__construct();

		// load model
		$this->load->model('Groups_model');
	}
    
    public function all()
	{
        $data = [];
		$get_data = $this->Groups_model->get_data()->result();

		if($get_data)
		{
			foreach($get_data as $row)
			{	
				
				$data[] = [
					'id'         => $row->group_id,
					'nama_group' => $row->group_name
				];
				
			}
            $code    = 200;
			$status  = true;
			$message = 'Berhasil';
		}
		else 
		{
			$code    = 200;
			$status  = false;
			$message = 'Gagal';
		}

		$response = [
            'code'    => $code,
			'success' => $status,
            'data'    => $data,
			'message' => $message,
        ];
        
		header('Content-Type: application/json');
		echo json_encode($response);
	}
	
	public function sub($id)
	{
        $data  = [];
        $where = array(
            'a.group_id' => $id,
        );
		$get_data = $this->Groups_model->get_data_child($where)->result();

		if($get_data)
		{
			foreach($get_data as $row)
			{
				$data[] = [
					'id'         => $row->group_child_id,
					'nama_group' => $row->group_child_name,
                ];
			}
            $status_code = 200;
			$status      = true;
			$message     = 'Berhasil';
		}
		else 
		{
			$status_code = 200;
			$status      = false;
			$message     = 'Gagal';
		}

		$response = [
            'code'    => $status_code,
			'success' => $status,
            'data'    => $data,
			'message' => $message,
        ];
        
		header('Content-Type: application/json');
		echo json_encode($response);
	}

}

?>
