<?php

/**
 * Sales Return Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use libraries\BaseController;

class Sales_returns extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Sales_returns_model');
		$this->load->model('Sales_orders_model');
		$this->load->model('Customers_model');
		// $this->load->model('Items_model');
		$this->load->model('Logs_model');
		$this->load->model('Warehouses_model');
		$this->load->model('Transfer_model');
		$this->load->model('Credits_model');
		$this->load->model('Journals_model');
		$this->load->model('Accounts_model');
		$this->load->model('Ppn_model');
		// $this->load->model('Wholesale_prices_model');
		// $this->load->model('Special_prices_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title'] = 'Retur Penjualan';
		$this->twiggy_display('adm/sales_returns/index', $data);
	}

	public function get_data_header()
	{
		$data = [];
		$order = "sales_return_header_date DESC, sales_return_header_number";
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");
		
		$startOfMonth = date('Y-m-01');
        $endOfMonth = date('Y-m-t');
		
		$where = [];
		$where['sales_return_header_date >='] = $startOfMonth;
        $where['sales_return_header_date <='] = $endOfMonth;
		if(isset($fromdate) && $fromdate != '')
		{
			$where['sales_return_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['sales_return_header_date <='] = change_format_date($todate);
		}
		$get_data = $this->Sales_returns_model->salesreturn_header($where, $order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$status = ($get_row->sales_return_header_status == 'Lunas' ? '<i class="fas fa-circle text-success"></i>&nbsp;&nbsp;&nbsp;Lunas' : '<i class="fas fa-circle text-warning"></i>&nbsp;&nbsp;&nbsp;Belum Lunas');
				$data[] = array(
					'no'          => $no,
					'id'          => $get_row->sales_return_header_id,
					'so_id'       => $get_row->sales_order_header_id,
					'number'      => $get_row->sales_return_header_number,
					'date'        => indonesian_date($get_row->sales_return_header_date),
					'customer'    => $get_row->customer_name,
					'tunai'       => number_format($get_row->sales_return_header_total_tunai),
					'potong'       => number_format($get_row->sales_return_header_total_hutang),
					'total'       => number_format($get_row->sales_return_header_grand_total),
					'description' => $get_row->sales_return_header_description,
					'status' => $status,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id = 'new')
	{
		$title = "Tambah Retur Penjualan";
		$return_data = array(null);

		$datenow = date('ym');
		$number_generator = '';
		$prefix     = 'RJ';
		$number_generator = $this->Sales_returns_model->salesreturn_autonumber();
		$autonumber = $prefix . $datenow . '-' . $number_generator;

		$rt_number = $autonumber;
		$rt_date   = date_now();
		$rt_description = '';

		$tmstamp   = date("H:i:s");
		$default_warehouse = $this->Warehouses_model->get_data(array('is_default' => '1'))->row()->warehouse_name;

		$customer_data = $this->Customers_model->get_data()->result();
		$sales_data  = '';
		$tunai = 0;
		
			$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
		$ppn_amount  = (empty($ppn_data) ? 0 : to_decimal($ppn_data->amount));

		if ($id != 'new') {
			$where       = array('sales_return_header_id' => $id);
			$return_data = $this->Sales_returns_model->salesreturn_header($where)->row_array();

			$title          = "Edit Retur Penjualan";
			$rt_number      = $return_data['sales_return_header_number'];
			$rt_date        = $return_data['sales_return_header_date'];
			$rt_description = $return_data['sales_return_header_description'];
// 			$ppn_amount   = $return_data['ppn_amount'];
	$ppn_data    = $this->Ppn_model->get_data(array('is_active' => '1'))->row();
		$ppn_amount  = (empty($ppn_data) ? 0 : to_decimal($ppn_data->amount));
			$sales_data  = $this->Sales_orders_model->salesorder_header(array('sales_order_header_customer_id' => $return_data['sales_return_header_customer_id']))->result();
			// $tmstamp        = time24($return_data['tmstamp_so']);
			// $default_warehouse = $this->Warehouses_model->get_data(array('is_default' => '1'))->row()->warehouse_name;
			if ($return_data['sales_return_header_total_tunai'] != 0)
				$tunai = number_format($return_data['sales_return_header_total_tunai']);
		}



		$data['default_warehouse'] = $default_warehouse;


		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['customer_data'] = $customer_data;
		$data['sales_data']    = $sales_data;
		$data['return_data']    = $return_data;
        $data['ppn_amount']      = $ppn_amount;
		$data['rt_number']      = $rt_number;
		$data['rt_date']        = $rt_date;
		$data['rt_description'] = $rt_description;
		$data['tunai'] = $tunai;

		$data['tmstamp'] = $tmstamp;

		$this->twiggy_display('adm/sales_returns/edit', $data);
	}

	public function get_number()
	{
		$id      = $this->input->post('id');


		$where       = array('sales_order_header_customer_id' => $id);
		$so_data = $this->Sales_orders_model->salesorder_header($where)->result();



		$response = [
			'id'           => $id,
			'so_data' => $so_data,
		];

		echo json_encode($response);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Barang';
		$this->twiggy_display('adm/sales_returns/embed', $data);
	}

	public function get_data_detail()
	{
		$id     = $this->input->post("id");
		$where  = array('sales_return_detail_header_id' => $id);
		$order  = array('item_name' => 'asc');

		$data = [];


		$get_data = $this->Sales_returns_model->salesreturn_detail($where)->result();
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$large_unit_quantity  = 0;
				$medium_unit_quantity = 0;
				$small_unit_quantity  = 0;
				$result_large  = 0;
				$result_medium = 0;
				$result_small  = 0;
				$total = 0;

				$large_unit_quantity  = to_decimal($get_row->sales_return_detail_large_unit_quantity);
				$medium_unit_quantity = to_decimal($get_row->sales_return_detail_medium_unit_quantity);
				$small_unit_quantity  = to_decimal($get_row->sales_return_detail_small_unit_quantity);
				$result_medium = number_format($get_row->sales_return_detail_result_medium);
				$result_small  = number_format($get_row->sales_return_detail_result_small);
				$large_price_order = number_format($get_row->sales_return_detail_large_unit_price);
				$medium_price_order = number_format($get_row->sales_return_detail_medium_unit_price);
				$small_price_order  = number_format($get_row->sales_return_detail_small_unit_price);
				$total = number_format($get_row->sales_return_detail_total);
                
                 $ppn_status_color = "";
				if ($get_row->sales_return_detail_ppn_status == '1') {
					$ppn_status_color = "";
				} elseif ($get_row->sales_return_detail_ppn_status == '2') {
					$ppn_status_color = "bg-success";
				} else {
					$ppn_status_color = "bg-warning";
				}


				$medium_price_order = ($medium_price_order == "0" ? (($get_row->sales_return_detail_large_unit_price / floor($get_row->large_unit_contain) * floor($get_row->medium_unit_contain))) : $medium_price_order);
				$small_price_order  = ($small_price_order == "0" ? ($get_row->sales_return_detail_large_unit_price / floor($get_row->large_unit_contain)) : $small_price_order);

				$total_stock = (($get_row->large_unit_contain * $get_row->sales_return_detail_large_unit_quantity)
					+ ($get_row->medium_unit_contain * $get_row->sales_return_detail_medium_unit_quantity)
					+ ($get_row->small_unit_contain * $get_row->sales_return_detail_small_unit_quantity));

				$data[] = array(
					'no'                => $no,
					'detail_id'         => $get_row->sales_return_detail_id,
					'detail_header_id'  => $get_row->sales_return_detail_header_id,
					'id'                => $get_row->sales_return_detail_item_id,
					'name'              => $get_row->sales_return_detail_item_name,
					'lg_unit'           => $get_row->sales_return_detail_large_unit,
					'lg_unit_cnt'       => floor($get_row->large_unit_contain),
					'lg_unit_qty' 		=> $large_unit_quantity,
					'lg_unit_qty_order' => floor($get_row->sales_return_detail_large_unit_quantity),
					'lg_unit_prc'       => $large_price_order,
					'result_large'      => $result_large,
					'md_unit'           => $get_row->sales_return_detail_medium_unit,
					'md_unit_cnt'       => floor($get_row->medium_unit_contain),
					'md_unit_qty' 		=> $medium_unit_quantity,
					'md_unit_qty_order' => floor($get_row->sales_return_detail_medium_unit_quantity),
					'md_unit_prc'       => $medium_price_order,
					'result_medium'     => $result_medium,
					'sm_unit'           => $get_row->sales_return_detail_small_unit,
					'sm_unit_cnt'       => floor($get_row->small_unit_contain),
					'sm_unit_qty' 		=> $small_unit_quantity,
					'sm_unit_qty_order' => floor($get_row->sales_return_detail_small_unit_quantity),
					'sm_unit_prc'       => $small_price_order,
					'result_small'      => $result_small,
					'ppn_status'         => $get_row->sales_return_detail_ppn_status,
    				'ppn_status_color'   => $ppn_status_color,
					// 'discount'          => number_format($get_row->sales_order_detail_discount_percentage),
					// 'discount_total'    => number_format($get_row->sales_order_detail_discount_total),
					// 'total'             => number_format($get_row->sales_order_detail_total),
					'discount'          => to_decimal($get_row->sales_return_detail_discount_percentage),
					'discount_total'    => number_format($get_row->sales_return_detail_discount_total),
					'total'             => $total,
					'total_stock'       => $total_stock,
					'total_stock_stored' => $total_stock,
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_data_detail_edit()
	{
		$id     = $this->input->post("id");
		$where  = array('sales_return_detail_header_id' => $id);
		$order  = array('item_name' => 'asc');

		$data = [];


		$get_data = $this->Sales_returns_model->salesreturn_detail($where)->result();
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$large_unit_quantity  = 0;
				$medium_unit_quantity = 0;
				$small_unit_quantity  = 0;
				$result_large  = 0;
				$result_medium = 0;
				$result_small  = 0;
				$total = 0;

				$large_unit_quantity  = to_decimal($get_row->sales_return_detail_large_unit_quantity);
				$medium_unit_quantity = to_decimal($get_row->sales_return_detail_medium_unit_quantity);
				$small_unit_quantity  = to_decimal($get_row->sales_return_detail_small_unit_quantity);
				$result_medium = number_format($get_row->sales_return_detail_result_medium);
				$result_small  = number_format($get_row->sales_return_detail_result_small);
				$large_price_order = number_format($get_row->sales_return_detail_large_unit_price);
				$medium_price_order = number_format($get_row->sales_return_detail_medium_unit_price);
				$small_price_order  = number_format($get_row->sales_return_detail_small_unit_price);
				$total = number_format($get_row->sales_return_detail_total);
				
				 $ppn_status_color = "";
				if ($get_row->sales_return_detail_ppn_status == '1') {
					$ppn_status_color = "";
				} elseif ($get_row->sales_return_detail_ppn_status == '2') {
					$ppn_status_color = "bg-success";
				} else {
					$ppn_status_color = "bg-warning";
				}


				$medium_price_order = ($medium_price_order == "0" ? (($get_row->sales_return_detail_large_unit_price / floor($get_row->large_unit_contain) * floor($get_row->medium_unit_contain))) : $medium_price_order);
				$small_price_order  = ($small_price_order == "0" ? ($get_row->sales_return_detail_large_unit_price / floor($get_row->large_unit_contain)) : $small_price_order);

				$total_stock = (($get_row->large_unit_contain * $get_row->sales_return_detail_large_unit_quantity)
					+ ($get_row->medium_unit_contain * $get_row->sales_return_detail_medium_unit_quantity)
					+ ($get_row->small_unit_contain * $get_row->sales_return_detail_small_unit_quantity));

				$data[] = array(
					'no'                => $no,
					'detail_id'         => $get_row->sales_return_detail_id,
					'detail_header_id'  => $get_row->sales_return_detail_header_id,
					'id'                => $get_row->sales_return_detail_item_id,
					'name'              => $get_row->sales_return_detail_item_name,
					'lg_unit'           => $get_row->sales_return_detail_large_unit,
					'lg_unit_cnt'       => floor($get_row->large_unit_contain),
					'lg_unit_qty' 		=> $large_unit_quantity,
					'lg_unit_qty_order' => floor($get_row->sales_return_detail_large_unit_quantity),
					'lg_unit_prc'       => $large_price_order,
					'result_large'      => $result_large,
					'md_unit'           => $get_row->sales_return_detail_medium_unit,
					'md_unit_cnt'       => floor($get_row->medium_unit_contain),
					'md_unit_qty' 		=> $medium_unit_quantity,
					'md_unit_qty_order' => floor($get_row->sales_return_detail_medium_unit_quantity),
					'md_unit_prc'       => $medium_price_order,
					'result_medium'     => $result_medium,
					'sm_unit'           => $get_row->sales_return_detail_small_unit,
					'sm_unit_cnt'       => floor($get_row->small_unit_contain),
					'sm_unit_qty' 		=> $small_unit_quantity,
					'sm_unit_qty_order' => floor($get_row->sales_return_detail_small_unit_quantity),
					'sm_unit_prc'       => $small_price_order,
					'result_small'      => $result_small,
						'ppn_status'         => $get_row->sales_return_detail_ppn_status,
    				'ppn_status_color'   => $ppn_status_color,
    				'discount'          => to_decimal($get_row->sales_return_detail_discount_percentage),
					'discount_total'    => number_format($get_row->sales_return_detail_discount_total),
					// 'discount'          => number_format($get_row->sales_order_detail_discount_percentage),
					// 'discount_total'    => number_format($get_row->sales_order_detail_discount_total),
					// 'total'             => number_format($get_row->sales_order_detail_total),
					'total'             => $total,
					'total_stock'       => $total_stock,
					'total_stock_stored' => $total_stock,
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_data_detail_by_faktur()
	{
		$id     = $this->input->post("id");
		$where  = array('sales_order_detail_header_id' => $id);
		$order  = array('item_name' => 'asc');

		$data = [];


		$get_data = $this->Sales_orders_model->salesorder_detail($where)->result();
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$retur_large_unit_quantity  = 0;
				$retur_medium_unit_quantity = 0;
				$retur_small_unit_quantity  = 0;

				$large_unit_quantity  = 0;
				$medium_unit_quantity = 0;
				$small_unit_quantity  = 0;
				$result_large  = 0;
				$result_medium = 0;
				$result_small  = 0;
				$total = 0;

				$where_retur = array('sales_order_header_id' => $get_row->sales_order_detail_header_id, 'sales_return_detail_item_id' => $get_row->sales_order_detail_item_id);
				$gdata_retur = $this->Sales_returns_model->salesreturn_lite($where_retur)->row();
				if ($gdata_retur) {
					$retur_large_unit_quantity  = $gdata_retur->sales_return_detail_large_unit_quantity;
					$retur_medium_unit_quantity = $gdata_retur->sales_return_detail_medium_unit_quantity;
					$retur_small_unit_quantity  = $gdata_retur->sales_return_detail_small_unit_quantity;
				}

                $ppn_status_color = "";
				if ($get_row->sales_order_detail_ppn_status == '1') {
					$ppn_status_color = "";
				} elseif ($get_row->sales_order_detail_ppn_status == '2') {
					$ppn_status_color = "bg-success";
				} else {
					$ppn_status_color = "bg-warning";
				}

				$large_unit_quantity  = to_decimal($get_row->sales_order_detail_large_unit_quantity - $retur_large_unit_quantity);
				$medium_unit_quantity = to_decimal($get_row->sales_order_detail_medium_unit_quantity - $retur_medium_unit_quantity);
				$small_unit_quantity  = to_decimal($get_row->sales_order_detail_small_unit_quantity - $retur_small_unit_quantity);
				$result_large         = number_format($get_row->sales_order_detail_result_large);
				$result_medium        = number_format($get_row->sales_order_detail_result_medium);
				$result_small         = number_format($get_row->sales_order_detail_result_small);
				$large_price_order    = number_format($get_row->sales_order_detail_large_unit_price);
				$medium_price_order   = number_format($get_row->sales_order_detail_medium_unit_price);
				$small_price_order    = number_format($get_row->sales_order_detail_small_unit_price);
				$total                = number_format($get_row->sales_order_detail_total);


				$medium_price_order = ($medium_price_order == "0" ? (($get_row->sales_order_detail_large_unit_price / to_decimal($get_row->large_unit_contain) * to_decimal($get_row->medium_unit_contain))) : $medium_price_order);
				$small_price_order  = ($small_price_order == "0" ? ($get_row->sales_order_detail_large_unit_price / to_decimal($get_row->large_unit_contain)) : $small_price_order);

				$total_stock = (($get_row->large_unit_contain * $large_unit_quantity)
					+ ($get_row->medium_unit_contain * $medium_unit_quantity)
					+ ($get_row->small_unit_contain * $small_unit_quantity));

				$data[] = array(
					'no'                => $no,
					'detail_id'         => $get_row->sales_order_detail_id,
					'detail_header_id'  => $get_row->sales_order_detail_header_id,
					'id'                => $get_row->sales_order_detail_item_id,
					'name'              => $get_row->sales_order_detail_item_name,
					'lg_unit'           => $get_row->sales_order_detail_large_unit,
					'lg_unit_cnt'       => to_decimal($get_row->large_unit_contain),
					'lg_unit_qty' 		=> 0,
					'lg_unit_qty_order' => to_decimal($large_unit_quantity),
					'lg_unit_prc'       => $large_price_order,
					'result_large'      => 0,
					'md_unit'           => $get_row->sales_order_detail_medium_unit,
					'md_unit_cnt'       => to_decimal($get_row->medium_unit_contain),
					'md_unit_qty' 		=> 0,
					'md_unit_qty_order' => to_decimal($medium_unit_quantity),
					'md_unit_prc'       => $medium_price_order,
					'result_medium'     => 0,
					'sm_unit'           => $get_row->sales_order_detail_small_unit,
					'sm_unit_cnt'       => to_decimal($get_row->small_unit_contain),
					'sm_unit_qty' 		=> 0,
					'sm_unit_qty_order' => to_decimal($small_unit_quantity),
					'sm_unit_prc'       => $small_price_order,
					'result_small'      => 0,
					'discount'          => to_decimal($get_row->sales_order_detail_discount_percentage),
					'discount_total'    => number_format($get_row->sales_order_detail_discount_total),
					'ppn_status'         => $get_row->sales_order_detail_ppn_status,
    				'ppn_status_color'   => $ppn_status_color,
    				'ppn_total'          => 0,
					'total'             => 0,
					'total_stock'       => $total_stock,
					'total_stock_stored' => $total_stock,
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_data_credit()
	{
		$data     = [];
		$response = [];
		$id       = $this->input->post('id');
		$customer = $this->input->post('customer');
		$search   = $this->input->post('search');

		$type = ($id == 'new' ? 'new' : 'edit');
		$get_data  = $this->Credits_model->salesorder_headersearch_credit($type, $customer, $search)->result();

		$no = 0;
		foreach ($get_data as $get_row) {
			$where        = array('sales_order_header_id' => $get_row->sales_order_header_id);
			$where_telah_bayar = array('credit_detail_sales_order_header_id' => $get_row->sales_order_header_id);
			$return_total = 0;
			$paid_total = 0;
			$disc_total = 0;
			$return_data  = $this->Credits_model->get_sum_retur($where)->row();
			$paid_data  = $this->Credits_model->get_sum_telah_bayar($where_telah_bayar)->row();
			if ($return_data) {
				$return_total = $return_data->total_retur;
			}
			if ($paid_data) {
				$paid_total = $paid_data->total_telah_bayar;
				$disc_total = $paid_data->total_disc;
			}
			$total = ($get_row->sales_order_header_grand_total - $return_total - $paid_total - $disc_total);
			if($total > 1){
    			$data[] = array(
    				'no'           => $no,
    				'id'           => $get_row->sales_order_header_id,
    				'number'       => $get_row->sales_order_header_number,
    				'date'         => indonesian_date($get_row->sales_order_header_date, 'd/m/Y'),
    				'sub_total'    => number_format($get_row->sales_order_header_grand_total),
    				'paid_total'   => number_format($paid_total + $disc_total),
    				'return_total' => number_format($return_total + $paid_total + $disc_total),
    				'total'        => number_format($total),
    				'total_bayar'        => number_format(0),
    			);
    
    			$no++;
			}
		}

		output_json($data);
	}

	public function get_data_credit_edit()
	{
		$data     = [];
		$response = [];
		$id       = $this->input->post('id');
		$so_id    = $this->input->post('so_id');
		$customer = $this->input->post('customer');
		$search   = $this->input->post('search');

		$type = ($id == 'new' ? 'new' : 'edit');
		$get_data  = $this->Credits_model->salesorder_headersearch_credit($type, $customer, $search)->result();

		$no = 0;
		foreach ($get_data as $get_row) {
			$where  = array('sales_order_header_id' => $get_row->sales_order_header_id);
			$where2 = array('sales_return_header_id' => $id, 'sales_order_header_id' => $get_row->sales_order_header_id);

			$where_telah_bayar = array('credit_detail_sales_order_header_id' => $get_row->sales_order_header_id);
			$where_telah_bayar2 = array(
				'credit_detail_sales_order_header_id' => $get_row->sales_order_header_id,
				'credit_header_retur_id' => $id
			);

			$return_total  = 0;
			$return_total2 = 0;
			$paid_total    = 0;
			$disc_total    = 0;
			$paid_total2   = 0;
			$disc_total2   = 0;
			$return_data   = $this->Credits_model->get_sum_retur($where)->row();
			$return_data2  = $this->Credits_model->get_sum_retur($where2)->row();
			$paid_data     = $this->Credits_model->get_sum_telah_bayar($where_telah_bayar)->row();
			$paid_data2    = $this->Credits_model->get_sum_telah_bayar($where_telah_bayar2)->row();
			if ($return_data) {
				$return_total = $return_data->total_retur;
			}
			if ($return_data2) {
				$return_total2 = $return_data2->total_retur;
			}
			if ($paid_data) {
				$paid_total = $paid_data->total_telah_bayar;
				$disc_total = $paid_data->total_disc;
			}

			if ($paid_data2) {
				$paid_total2 = $paid_data2->total_telah_bayar;
				$disc_total2 = $paid_data2->total_disc;
			}
			$total = ($get_row->sales_order_header_grand_total - $return_total - $paid_total - $disc_total);
			$data[] = array(
				'no'           => $no,
				'id'           => $get_row->sales_order_header_id,
				'number'       => $get_row->sales_order_header_number,
				'date'         => indonesian_date($get_row->sales_order_header_date, 'd/m/Y'),
				'sub_total'    => number_format($get_row->sales_order_header_grand_total),
				'paid_total'   => number_format($paid_total + $disc_total),
				'return_total' => number_format($return_total + $paid_total + $disc_total),
				'total'        => number_format($total + $paid_total2 + $return_total2),
				'total_bayar'  => number_format($paid_total2),
			);

			$no++;
		}

		output_json($data);
	}

	public function save()
	{
		$id             = $this->input->post('id');
		$number         = $this->input->post("number");
		$number_so         = $this->input->post("number_so");
		$date           = $this->input->post("date");
		$customer       = $this->input->post("customer");
		// $payment_method = $this->input->post("payment_method");
		// $payment_term   = $this->input->post("payment_term");
		// $payment_due    = $this->input->post("payment_due");
		$ppn_total       = $this->input->post("ppn_total");
		$total_retur  = $this->input->post("total_retur");
		$total_hutang = $this->input->post("total_hutang");
		$total_tunai  = $this->input->post("total_tunai");
		$grand_total  = $this->input->post("grand_total");
		$grand_total    = $this->input->post("grand_total");
		$description    = $this->input->post("description");

		$tmstamp         = $this->input->post("tmstamp");

		$vuedata = $this->input->post('vuedata');
		$db_vuedata = $this->input->post('db_vuedata');

		// $payment_term_data = ($payment_term == "" ? "0" : substr($payment_term ,0 ,-5));
		// $payment_due_data  = ($payment_due == "" ? "0000-00-00" : change_format_date($payment_due));

		$header_id   = $id;
        $total_status_1 = 0;
        $total_status_2 = 0;
        $total_status_3=0;
		$trheader_id       = 0;
		$default_warehouse = $this->Warehouses_model->get_data(array('is_default' => '1'))->row_array();
		$transfer_number   = $this->Transfer_model->transfer_autonumber();
		$prefix            = 'TF';
		$datenow           = date('ym');
		$autonumber        = $prefix . $datenow . '-' . $transfer_number;

		$status_bayar = 'Lunas';
		if (trims($total_retur) > (trims($total_hutang) + trims($total_tunai))) {
			$status_bayar = 'Belum Lunas';
		}
		$header_data = [
			'sales_order_header_id'     	  => $number_so,
			'sales_return_header_number'      => $number,
			'sales_return_header_date'        => change_format_date($date),
			'sales_return_header_customer_id' => $customer,
			'sales_return_header_grand_total' => trims($total_retur),
			'sales_return_header_ppn_total'       => trims($ppn_total),
			'sales_return_header_total_hutang' => trims($total_hutang),
			'sales_return_header_total_tunai'  => trims($total_tunai),
			'sales_return_header_description' => $description,
			'sales_return_header_status'  => $status_bayar,
		];

// 		$trheader_data = [
// 			'header_number' => $autonumber,
// 			'header_date'   => change_format_date($date),
// 			'gudang_from'   => 0,
// 			'header_to'     => $default_warehouse['warehouse_id']
// 		];

		$detail_data = [];
		$log_data = [];
		$hpp = 0;

		// if save $id = new else update data
		if ($id == "new") {
			// save header
			$save_header = $this->Sales_returns_model->save_header($header_data);
			if ($save_header) {
				$header_id = $this->db->insert_id();

				// $save_trheader = $this->Transfer_model->save_header($trheader_data);
				// $trheader_id = $this->db->insert_id();
				foreach ($vuedata as $row) {
					$detail_data[] = [
						'sales_return_detail_header_id'            => $header_id,
						'sales_return_detail_item_id'              => $row['id'],
						'sales_return_detail_item_name'            => $row['name'],
						'sales_return_detail_large_unit'           => $row['lg_unit'],
						'sales_return_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
						'sales_return_detail_large_unit_price'     => trims($row['lg_unit_prc']),
						'sales_return_detail_result_large'         => trims($row['result_large']),
						'sales_return_detail_medium_unit'          => $row['md_unit'],
						'sales_return_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
						'sales_return_detail_medium_unit_price'    => trims($row['md_unit_prc']),
						'sales_return_detail_result_medium'        => trims($row['result_medium']),
						'sales_return_detail_small_unit'           => $row['sm_unit'],
						'sales_return_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
						'sales_return_detail_small_unit_price'     => trims($row['sm_unit_prc']),
						'sales_return_detail_result_small'         => trims($row['result_small']),
						'sales_return_detail_ppn_status'           => $row['ppn_status'],
						'sales_return_detail_ppn_total'            => trims($row['ppn_total']),
						'sales_return_detail_discount_percentage'            => trims($row['discount']),
						'sales_return_detail_discount_total'            => trims($row['discount_total']),
						'sales_return_detail_total'                => trims($row['total'])
					];
					
						if($row['ppn_status'] == 1){
						    $total_status_1 += trims($row['total']);
						}
						
						if($row['ppn_status'] == 2){
						    $total_status_2 += trims($row['total']);
						}
						if($row['ppn_status'] == 3){
						    $total_status_3 += trims($row['total']);
						}

				// 	$trdetail_data[] = [
				// 		'header_id'      => $trheader_id,
				// 		'transaction_id' => $header_id,
				// 		'item_id'        => $row['id'],
				// 		'lg_qty'         => trims($row['lg_unit_qty']),
				// 		'md_qty'         => trims($row['md_unit_qty']),
				// 		'sm_qty'         => trims($row['sm_unit_qty']),
				// 		'status'         => "R-SELL",
				// 	];

					// $where                 = array('log_item_id' => $row['id']);
					$dtstamp                    = change_format_date($date) . " " . date("H:i:s");
					$where                      = array('log_item_id' => $row['id'], 'a.timestamp <' => $dtstamp);
					$log_data_check             = $this->Logs_model->get_data_last($where)->row_array();
					$last_total_stock           = 0;
					$last_log_total_stock_value = 0;

					if (!empty($log_data_check)) {
						$last_total_stock      		= $log_data_check['log_total_stock'];
						$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
					}

					$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * trims($row['lg_unit_qty'])) + ($row['md_unit_cnt'] * trims($row['md_unit_qty'])) + ($row['sm_unit_cnt'] * trims($row['sm_unit_qty']));
					$log_total_transaction_value = (trims($row['lg_unit_qty']) * trims($row['lg_unit_prc'])) + (trims($row['md_unit_qty']) * trims($row['md_unit_prc'])) + (trims($row['sm_unit_qty']) * trims($row['sm_unit_prc']));
					$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
					$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
					$log_average_small_unit      = 0;
					$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
					$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);
					$log_data[] = [
						'log_type'                            => 'R-SELL',
						'log_transaction_id'                  => $header_id,
						'log_item_id'                         => $row['id'],
						'log_large_unit'                      => $row['lg_unit'],
						'log_large_unit_contain'              => $row['lg_unit_cnt'],
						'log_large_unit_quantity'             => trims($row['lg_unit_qty']),
						'log_large_unit_purchase_price'       => trims($row['lg_unit_prc']),
						'log_medium_unit'                     => $row['md_unit'],
						'log_medium_unit_contain'             => $row['md_unit_cnt'],
						'log_medium_unit_quantity'            => trims($row['md_unit_qty']),
						'log_medium_unit_purchase_price'      => trims($row['md_unit_prc']),
						'log_small_unit'                      => $row['sm_unit'],
						'log_small_unit_contain'              => $row['sm_unit_cnt'],
						'log_small_unit_quantity'             => trims($row['sm_unit_qty']),
						'log_small_unit_purchase_price'       => trims($row['sm_unit_prc']),
						'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
						'log_total_transaction_value'         => $log_total_transaction_value,
						'log_total_stock'                     => $log_total_stock,
						'log_total_stock_value'               => $log_total_stock_value,
						'log_average_large_unit'              => $log_average_large_unit,
						'log_average_medium_unit'             => $log_average_medium_unit,
						'log_average_small_unit'              => $log_average_small_unit,
						'timestamp'                           => $dtstamp
					];
					
					$where_last_price   = array('a.log_item_id' => $row['id'], 'log_type' => 'BUY');
					        $get_log = $this->Logs_model->get_data_last($where_last_price)->row();
					        if($get_log){
					            $hpp += $get_log->log_large_unit_purchase_price * trims($row['lg_unit_qty']);
					        }else{
					            $hpp += $row['lg_unit_prc'] * trims($row['lg_unit_qty']);
					        }
							

					// $data_item = array(
					// 	'last_purchase_price_large_unit'  => trims($row['lg_unit_prc']),
					// 	'last_purchase_price_medium_unit' => trims($row['md_unit_prc']),
					// 	'last_purchase_price_small_unit'  => trims($row['sm_unit_prc']),
					// );

					// $where_item = $row['id'];

					// $update_item = $this->Items_model->update($where_item, $data_item);
				}

				$save_detail = $this->Sales_returns_model->save_detail($detail_data, true);
				// $save_trdetail = $this->Transfer_model->save_detail($trdetail_data, true);

				if ($save_detail) {
					$save_log = $this->Logs_model->save($log_data, true);

					if ($save_log) {
						$update_log = $this->update_log($vuedata, $header_id, $date);
						// $update_log = true;
						if ($update_log) {

							$db_prefix  = "CR-TX";
							$db_datenow          = date('mY');
							$db_number_generator = $this->Credits_model->credit_autonumber();
							$db_autonumber = $db_prefix . $db_datenow . $db_number_generator;

							$db_header_data = [
								'credit_header_number'         => $db_autonumber,
								'credit_header_retur_id'       => $header_id,
								'credit_header_date'           => change_format_date($date),
								'credit_header_customer_id'    => $customer,
								'credit_header_bank_id'        => 0,
								'credit_header_payment_method' => 'Tunai/Lainnya',
								'credit_header_number_giro'    => '',
								'credit_header_payment_due'    => '',
								'credit_header_sub_total'      => trims($total_hutang),
								'credit_header_return_total'   => 0,
								'credit_header_grand_total'    => trims($total_hutang),
								'credit_header_total_hutang'   => trims($total_hutang),
								'credit_header_bayar_total'    => trims($total_hutang),
								'credit_header_total_tunai'    => trims($total_tunai),
								'credit_header_description'    => '',
								'from_retur'                    => 1
							];

							$db_save_header = $this->Credits_model->save_header($db_header_data);
							if ($db_save_header) {
								$db_header_id = $this->db->insert_id();
								if ($db_vuedata != NULL) {
									foreach ($db_vuedata as $db_row) {
									    if($db_row['total_bayar']){
									        if ($db_row['total_bayar'] > 0) {
    											$db_detail_data[] = [
    												'credit_detail_header_id'                => $db_header_id,
    												'credit_detail_sales_order_header_id' => $db_row['id'],
    												'credit_detail_price'                    => trims($db_row['total']),
    												'credit_detail_discount_percentage'      => 0,
    												'credit_detail_discount_total'           => 0,
    												'credit_detail_return_total'             => 0,
    												'credit_detail_total'                    => trims($db_row['total']),
    												'credit_detail_bayar'                    => trims($db_row['total_bayar']),
    											];
    										}
    
    										if (trims($db_row['total']) == trims($db_row['total_bayar'])) {
    											$update_lunas[] = [
    												'sales_order_header_id' => $db_row['id'],
    												'status_paid'              => 1,
    											];
    										}
									    }
										
									}
								}

								if (!empty($update_lunas)) {
									$update_lunas_so = $this->Sales_returns_model->update_lunas_so($update_lunas);
								}

								$db_save_detail = false;
								$db_delete_header = false;
								if (!empty($db_detail_data)) {
									$db_save_detail = $this->Credits_model->save_detail($db_detail_data, true);
								} else {
									$db_delete_header = $this->Credits_model->delete_header($db_header_id);
								}

								if ($db_save_detail || $db_delete_header) {

									$save_journal = $this->save_journal($header_id, $total_retur, $total_tunai, $number,trims($ppn_total),$total_status_1,$total_status_2,$total_status_3,$total_hutang,$hpp);

									// $prefix_jr           = "JR";
									// $datenow_jr          = date('Ym');
									// $number_generator_jr = $this->Journals_model->journal_autonumber();
									// $autonumber_jr       = $prefix_jr . $datenow_jr . $number_generator_jr;

									// $header_data_jr = [
									// 	'journal_header_number'       => $autonumber_jr,
									// 	'journal_header_trx_id'       => $header_id,
									// 	'journal_header_trx_type'     => "R-SELL",
									// 	'journal_header_date'         => change_format_date($date),
									// 	'journal_header_total_debit'  => trims($total_retur),
									// 	'journal_header_total_credit' => trims($total_retur),
									// 	'journal_header_description'  => $number,
									// ];

									// $save_header_jr = $this->Journals_model->save_header($header_data_jr);
									// $header_id_jr = $this->db->insert_id();

									// $detail_data_jr = [

									// 	[
									// 		'journal_detail_header_id'      => $header_id_jr,
									// 		'journal_detail_trx_id'         => $header_id,
									// 		'journal_detail_trx_type'       => "R-SELL",
									// 		'journal_detail_account_id'     => '27',
									// 		'journal_detail_account_number' => '40000000301',
									// 		'journal_detail_account_name'   => 'Retur Penjualan',
									// 		'journal_detail_debit'          => trims($total_retur),
									// 		'journal_detail_credit'         => 0,
									// 		'journal_detail_description'    => ''
									// 	],

									// 	[
									// 		'journal_detail_header_id'      => $header_id_jr,
									// 		'journal_detail_trx_id'         => $header_id,
									// 		'journal_detail_trx_type'       => "R-SELL",
									// 		'journal_detail_account_id'     => '19',
									// 		'journal_detail_account_number' => '210000019',
									// 		'journal_detail_account_name'   => 'Piutang Usaha',
									// 		'journal_detail_debit'          => 0,
									// 		'journal_detail_credit'         => trims($total_retur),
									// 		'journal_detail_description'    => ''
									// 	],

									// 	[
									// 		'journal_detail_header_id'      => $header_id_jr,
									// 		'journal_detail_trx_id'         => $header_id,
									// 		'journal_detail_trx_type'       => "R-SELL",
									// 		'journal_detail_account_id'     => '20',
									// 		'journal_detail_account_number' => '11000035',
									// 		'journal_detail_account_name'   => 'Persediaan Material',
									// 		'journal_detail_debit'          => trims($total_retur),
									// 		'journal_detail_credit'         => 0,
									// 		'journal_detail_description'    => ''
									// 	],

									// 	[
									// 		'journal_detail_header_id'      => $header_id_jr,
									// 		'journal_detail_trx_id'         => $header_id,
									// 		'journal_detail_trx_type'       => "SELL",
									// 		'journal_detail_account_id'     => '35',
									// 		'journal_detail_account_number' => '5000007002',
									// 		'journal_detail_account_name'   => 'Harga Pokok Penjualan',
									// 		'journal_detail_debit'          => 0,
									// 		'journal_detail_credit'         => trims($total_retur),
									// 		'journal_detail_description'    => ''
									// 	],


									// ];

									// $save_detail_jr = $this->Journals_model->save_detail($detail_data_jr, true);

									$msg    = "Berhasil menyimpan data";
									$status = "success";
								} else {
									$msg    = "Gagal menyimpan data";
									$status = "error";
								}
							}
						} else {
							$msg    = "Gagal menyimpan data #CKP-U01";
							$status = "error";
						}
					} else {
						$msg    = "Gagal menyimpan data";
						$status = "error";
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		} else {
			// This New Update
// 			$id_transfer  = $this->Transfer_model->transfer_detail(array('transaction_id' => $header_id, 'status' => 'R-SELL'))->row()->header_id;
			$id_credit  = $this->Credits_model->credit_header_lite(array('credit_header_retur_id' => $header_id))->row()->id;

			$delete_detail = $this->Sales_returns_model->delete_detail($id);

// 			$tf_delheader = $this->Transfer_model->delete_header($id_transfer);
// 			$tf_deldetail = $this->Transfer_model->delete_detail($id_transfer);

			$db_delheader = $this->Credits_model->delete_headerbyretur($header_id);
			$db_deldetail = $this->Credits_model->delete_detail($id_credit);

			if ($delete_detail) {

				// $delete_log = $this->delete_log($id);
				$delete_log = $this->Logs_model->delete(array('log_transaction_id' => $id, 'log_type' => 'R-SELL'));

				$jr_delheader = $this->Journals_model->delete_headerbytrxid($header_id, "R-SELL");
				$jr_deldetail = $this->Journals_model->delete_detailbytrxid($header_id, "R-SELL");

				if ($delete_log) {
					$save_header = $this->Sales_returns_model->update_header($id, $header_data);
					$delete_journal = $this->delete_journal($id);

					if ($save_header) {
				// 		$save_trheader = $this->Transfer_model->save_header($trheader_data);
				// 		$trheader_id = $this->db->insert_id();
						// $header_id = $this->db->insert_id();
						foreach ($vuedata as $row) {
							$detail_data[] = [
								'sales_return_detail_header_id'            => $header_id,
								'sales_return_detail_item_id'              => $row['id'],
								'sales_return_detail_item_name'            => $row['name'],
								'sales_return_detail_large_unit'           => $row['lg_unit'],
								'sales_return_detail_large_unit_quantity'  => trims($row['lg_unit_qty']),
								'sales_return_detail_large_unit_price'     => trims($row['lg_unit_prc']),
								'sales_return_detail_result_large'         => trims($row['result_large']),
								'sales_return_detail_medium_unit'          => $row['md_unit'],
								'sales_return_detail_medium_unit_quantity' => trims($row['md_unit_qty']),
								'sales_return_detail_medium_unit_price'    => trims($row['md_unit_prc']),
								'sales_return_detail_result_medium'        => trims($row['result_medium']),
								'sales_return_detail_small_unit'           => $row['sm_unit'],
								'sales_return_detail_small_unit_quantity'  => trims($row['sm_unit_qty']),
								'sales_return_detail_small_unit_price'     => trims($row['sm_unit_prc']),
								'sales_return_detail_result_small'         => trims($row['result_small']),
								'sales_return_detail_ppn_status'           => $row['ppn_status'],
						'sales_return_detail_ppn_total'            => trims(0),
						'sales_return_detail_discount_percentage'            => trims($row['discount']),
						'sales_return_detail_discount_total'            => trims($row['discount_total']),
								'sales_return_detail_total'                => trims($row['total'])
							];
							
							if($row['ppn_status'] == 1){
						    $total_status_1 += trims($row['total']);
						}
						
						if($row['ppn_status'] == 2){
						    $total_status_2 += trims($row['total']);
						}
						if($row['ppn_status'] == 3){
						    $total_status_3 += trims($row['total']);
						}

							// $where                 = array('log_item_id' => $row['id'], 'a.timestamp <' => $tmstamp);
							$dtstamp                    = change_format_date($date) . " " . $tmstamp;
							$where                      = array('log_item_id' => $row['id'], 'a.timestamp <' => $dtstamp);
							$log_data_check             = $this->Logs_model->get_data_last($where)->row_array();
							$last_total_stock           = 0;
							$last_log_total_stock_value = 0;
							$last_log_avg_large         = 0;
							$last_log_avg_medium        = 0;
							$last_log_avg_small         = 0;

							if (!empty($log_data_check)) {
								$last_total_stock           = $log_data_check['log_total_stock'];
								$last_log_total_stock_value = $log_data_check['log_total_stock_value'];
								$last_log_avg_large         = $log_data_check['log_average_large_unit'];
								$last_log_avg_medium        = $log_data_check['log_average_medium_unit'];
								$last_log_avg_small         = $log_data_check['log_average_small_unit'];
							}

							$medium_purchase_price = ($row['md_unit_cnt'] == 0 ? 0 : ($last_log_avg_medium));
							$small_purchase_price  = ($row['sm_unit_cnt'] == 0 ? 0 : ($last_log_avg_small));

							$log_total_transaction_in_small_unit = ($row['lg_unit_cnt'] * (trims($row['lg_unit_qty']))) + ($row['md_unit_cnt'] * (trims($row['md_unit_qty']))) + ($row['sm_unit_cnt'] * (trims($row['sm_unit_qty'])));
							$log_total_transaction_value = ((trims($row['lg_unit_qty'])) * $last_log_avg_large) + ((trims($row['md_unit_qty'])) * $medium_purchase_price) + ((trims($row['sm_unit_qty'])) * $small_purchase_price);
							$log_total_stock		     = ($last_total_stock + $log_total_transaction_in_small_unit);
							$log_total_stock_value       = ($last_log_total_stock_value + $log_total_transaction_value);
							$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
							$log_average_medium_unit     = ($log_average_small_unit * $row['md_unit_cnt']);
							$log_average_large_unit      = ($log_average_small_unit * $row['lg_unit_cnt']);

							$log_data[] = [
								'log_type'                            => 'R-SELL',
								'log_transaction_id'                  => $header_id,
								'log_item_id'                         => $row['id'],
								'log_large_unit'                      => $row['lg_unit'],
								'log_large_unit_contain'              => $row['lg_unit_cnt'],
								'log_large_unit_quantity'             => trims($row['lg_unit_qty']),
								'log_large_unit_purchase_price'       => trims($row['lg_unit_prc']),
								'log_medium_unit'                     => $row['md_unit'],
								'log_medium_unit_contain'             => $row['md_unit_cnt'],
								'log_medium_unit_quantity'            => trims($row['md_unit_qty']),
								'log_medium_unit_purchase_price'      => trims($row['md_unit_prc']),
								'log_small_unit'                      => $row['sm_unit'],
								'log_small_unit_contain'              => $row['sm_unit_cnt'],
								'log_small_unit_quantity'             => trims($row['sm_unit_qty']),
								'log_small_unit_purchase_price'       => trims($row['sm_unit_prc']),
								'log_total_transaction_in_small_unit' => $log_total_transaction_in_small_unit,
								'log_total_transaction_value'         => $log_total_transaction_value,
								'log_total_stock'                     => $log_total_stock,
								'log_total_stock_value'               => $log_total_stock_value,
								'log_average_large_unit'              => $log_average_large_unit,
								'log_average_medium_unit'             => $log_average_medium_unit,
								'log_average_small_unit'              => $log_average_small_unit,
								'timestamp'                           => $dtstamp
							];
							$where_last_price   = array('a.log_item_id' => $row['id'], 'log_type' => 'BUY');
					        $get_log = $this->Logs_model->get_data_last($where_last_price)->row();
							if($get_log){
					            $hpp += $get_log->log_large_unit_purchase_price * trims($row['lg_unit_qty']);
					        }else{
					            $hpp += $row['lg_unit_prc'] * trims($row['lg_unit_qty']);
					        }

				// 			$trdetail_data[] = [
				// 				'header_id'      => $trheader_id,
				// 				'transaction_id' => $header_id,
				// 				'item_id'        => $row['id'],
				// 				'lg_qty'         => trims($row['lg_unit_qty']),
				// 				'md_qty'         => trims($row['md_unit_qty']),
				// 				'sm_qty'         => trims($row['sm_unit_qty']),
				// 				'status'         => "R-SELL",
				// 			];
						}

						$save_detail = $this->Sales_returns_model->save_detail($detail_data, true);
				// 		$save_trdetail = $this->Transfer_model->save_detail($trdetail_data, true);

						if ($save_detail) {

							$save_log = $this->Logs_model->save($log_data, true);

							if ($save_log) {
								$update_log = $this->update_log($vuedata, $header_id, $date);
								// $update_log = true;
								if ($update_log) {

									$db_prefix  = "CR-TX";
									$db_datenow          = date('mY');
									$db_number_generator = $this->Credits_model->credit_autonumber();
									$db_autonumber = $db_prefix . $db_datenow . $db_number_generator;

									$db_header_data = [
										'credit_header_number'         => $db_autonumber,
										'credit_header_retur_id'       => $header_id,
										'credit_header_date'           => change_format_date($date),
										'credit_header_customer_id'    => $customer,
										'credit_header_bank_id'        => 0,
										'credit_header_payment_method' => 'Tunai/Lainnya',
										'credit_header_number_giro'    => '',
										'credit_header_payment_due'    => '',
										'credit_header_sub_total'      => trims($total_hutang),
										'credit_header_return_total'   => 0,
										'credit_header_grand_total'    => trims($total_hutang),
										'credit_header_total_hutang'   => trims($total_hutang),
										'credit_header_bayar_total'    => trims($total_hutang),
										'credit_header_total_tunai'    => trims($total_tunai),
										'credit_header_description'    => '',
										'from_retur'                    => 1
									];

									$db_save_header = $this->Credits_model->save_header($db_header_data);
									if ($db_save_header) {
										$db_header_id = $this->db->insert_id();
										if ($db_vuedata != NULL) {
											foreach ($db_vuedata as $db_row) {
												if($db_row){
									        if ($db_row['total_bayar'] > 0) {
    											$db_detail_data[] = [
    												'credit_detail_header_id'                => $db_header_id,
    												'credit_detail_sales_order_header_id' => $db_row['id'],
    												'credit_detail_price'                    => trims($db_row['total']),
    												'credit_detail_discount_percentage'      => 0,
    												'credit_detail_discount_total'           => 0,
    												'credit_detail_return_total'             => 0,
    												'credit_detail_total'                    => trims($db_row['total']),
    												'credit_detail_bayar'                    => trims($db_row['total_bayar']),
    											];
    										}
    
    										if (trims($db_row['total']) == trims($db_row['total_bayar'])) {
    											$update_lunas[] = [
    												'sales_order_header_id' => $db_row['id'],
    												'status_paid'              => 1,
    											];
    										}
									    }
											}
										}

										if (!empty($update_lunas)) {
											$update_lunas_so = $this->Sales_returns_model->update_lunas_so($update_lunas);
										}

										$db_save_detail = false;
										$db_delete_header = false;
										if (!empty($db_detail_data)) {
											$db_save_detail = $this->Credits_model->save_detail($db_detail_data, true);
										} else {
											$db_delete_header = $this->Credits_model->delete_header($db_header_id);
										}

										if ($db_save_detail || $db_delete_header) {
											$save_journal = $this->save_journal($header_id, $total_retur, $total_tunai, $number,trims($ppn_total),$total_status_1,$total_status_2,$total_status_3,$total_hutang,$hpp);

											// $prefix_jr           = "JR";
											// $datenow_jr          = date('Ym');
											// $number_generator_jr = $this->Journals_model->journal_autonumber();
											// $autonumber_jr       = $prefix_jr . $datenow_jr . $number_generator_jr;

											// $header_data_jr = [
											// 	'journal_header_number'       => $autonumber_jr,
											// 	'journal_header_trx_id'       => $header_id,
											// 	'journal_header_trx_type'     => "R-SELL",
											// 	'journal_header_date'         => change_format_date($date),
											// 	'journal_header_total_debit'  => trims($total_retur),
											// 	'journal_header_total_credit' => trims($total_retur),
											// 	'journal_header_description'  => $number,
											// ];

											// $save_header_jr = $this->Journals_model->save_header($header_data_jr);
											// $header_id_jr = $this->db->insert_id();

											// $detail_data_jr = [

											// 	[
											// 		'journal_detail_header_id'      => $header_id_jr,
											// 		'journal_detail_trx_id'         => $header_id,
											// 		'journal_detail_trx_type'       => "R-SELL",
											// 		'journal_detail_account_id'     => '27',
											// 		'journal_detail_account_number' => '40000000301',
											// 		'journal_detail_account_name'   => 'Retur Penjualan',
											// 		'journal_detail_debit'          => trims($total_retur),
											// 		'journal_detail_credit'         => 0,
											// 		'journal_detail_description'    => ''
											// 	],

											// 	[
											// 		'journal_detail_header_id'      => $header_id_jr,
											// 		'journal_detail_trx_id'         => $header_id,
											// 		'journal_detail_trx_type'       => "R-SELL",
											// 		'journal_detail_account_id'     => '19',
											// 		'journal_detail_account_number' => '210000019',
											// 		'journal_detail_account_name'   => 'Piutang Usaha',
											// 		'journal_detail_debit'          => 0,
											// 		'journal_detail_credit'         => trims($total_retur),
											// 		'journal_detail_description'    => ''
											// 	],

											// 	[
											// 		'journal_detail_header_id'      => $header_id_jr,
											// 		'journal_detail_trx_id'         => $header_id,
											// 		'journal_detail_trx_type'       => "R-SELL",
											// 		'journal_detail_account_id'     => '20',
											// 		'journal_detail_account_number' => '11000035',
											// 		'journal_detail_account_name'   => 'Persediaan Material',
											// 		'journal_detail_debit'          => trims($total_retur),
											// 		'journal_detail_credit'         => 0,
											// 		'journal_detail_description'    => ''
											// 	],

											// 	[
											// 		'journal_detail_header_id'      => $header_id_jr,
											// 		'journal_detail_trx_id'         => $header_id,
											// 		'journal_detail_trx_type'       => "SELL",
											// 		'journal_detail_account_id'     => '35',
											// 		'journal_detail_account_number' => '5000007002',
											// 		'journal_detail_account_name'   => 'Harga Pokok Penjualan',
											// 		'journal_detail_debit'          => 0,
											// 		'journal_detail_credit'         => trims($total_retur),
											// 		'journal_detail_description'    => ''
											// 	],


											// ];

											// $save_detail_jr = $this->Journals_model->save_detail($detail_data_jr, true);

											$msg    = "Berhasil menyimpan data";
											$status = "success";
										} else {
											$msg    = "Gagal menyimpan data";
											$status = "error";
										}
									}
								} else {
									$msg    = "Gagal menyimpan data #CKP-U01";
									$status = "error";
								}
							} else {
								$msg    = "Gagal menyimpan data #LOG-S01";
								$status = "error";
							}
						} else {
							$msg    = "Gagal menyimpan data #LOG-U01";
							$status = "error";
						}
					} else {
						$msg    = "Gagal menyimpan data #HED-U01";
						$status = "error";
					}
				} else {
				}
			} else {
				$msg    = "Gagal menyimpan data #DEL-U01";
				$status = "error";
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);
	}

	public function save_journal($header_id, $sub_total, $total_tunai, $number,$ppn,$total_status_1,$total_status_2,$total_status_3,$total_hutang,$hpp)
	{
		$prefix           = "JR";
		$datenow          = date('Ym');
		$number_generator = $this->Journals_model->journal_autonumber();
		$autonumber       = $prefix . $datenow . $number_generator;

		$header_data = [
			// 'journal_header_number'       => ($id == "new" ? $autonumber : $number),
			'journal_header_trx_id'       => $header_id,
			'journal_header_trx_type'     => "RSELL",
			'journal_header_number'       => ($autonumber),
			'journal_header_date'         => date_now(),
			'journal_header_total_debit'  => trims($sub_total),
			'journal_header_total_credit' => trims($sub_total),
			'journal_header_description'  => $number,
		];

		$detail_data = [];

		if($total_tunai == 0){
			$account =  $this->Accounts_model->get_data_settings_advance(array('trx_type' => 'SORK'))->result();
		}else{
			$account =  $this->Accounts_model->get_data_settings_advance(array('trx_type' => 'SOR'))->result();
		}

		$save_header_jr = $this->Journals_model->save_header($header_data);
		$header_id_jr = $this->db->insert_id();

		foreach ($account as $get_row) {
		    
		    

			$status = $get_row->status;
			if($get_row->account_id == 27){
 			    if($total_status_1 != 0){
 			        $detail_data[] = [
        				'journal_detail_trx_id'         => $header_id,
    				'journal_detail_trx_type'       => "RSELL",
    				'journal_detail_header_id'      => $header_id_jr,
    				'journal_detail_account_id'     => $get_row->account_id,
    				'journal_detail_account_number' => $get_row->account_number,
    				'journal_detail_account_name'   => $get_row->account_name,
    				'journal_detail_account_group'      => $get_row->account_group_name,
    				'journal_detail_debit'         => ($get_row->account_name != "PPN KELUARAN"  ? ($get_row->account_name != "Persediaan"  ? ($status == "D" ? $total_status_1 : 0) : ($status == "D" ? $total_status_1 : 0)) : ($status == "D" ? $ppn : 0)),
    				'journal_detail_credit'          => ($status == "K" ? $total_status_1 : 0),
    			
    				'journal_detail_description'    => "NON-PPN"
        			];
 			    }
     			
    			if($total_status_2 != 0){
    			    $detail_data[] = [
        				'journal_detail_trx_id'         => $header_id,
    				'journal_detail_trx_type'       => "RSELL",
    				'journal_detail_header_id'      => $header_id_jr,
    				'journal_detail_account_id'     => $get_row->account_id,
    				'journal_detail_account_number' => $get_row->account_number,
    				'journal_detail_account_name'   => $get_row->account_name,
    				'journal_detail_account_group'      => $get_row->account_group_name,
    				'journal_detail_debit'         => ($get_row->account_name != "PPN KELUARAN"  ? ($get_row->account_name != "Persediaan"  ? ($status == "D" ? trims($total_status_2) - $ppn : 0) : ($status == "D" ? trims($total_status_2) : 0)) : ($status == "D" ? $ppn : 0)),
    				'journal_detail_credit'          => ($status == "K" ? trims($total_status_2) : 0),
    			
    				'journal_detail_description'    => "PPN"
    			    ];
    			}
    			if($total_status_3 != 0){
    			    $detail_data[] = [
        					'journal_detail_trx_id'         => $header_id,
    				'journal_detail_trx_type'       => "RSELL",
    				'journal_detail_header_id'      => $header_id_jr,
    				'journal_detail_account_id'     => $get_row->account_id,
    				'journal_detail_account_number' => $get_row->account_number,
    				'journal_detail_account_name'   => $get_row->account_name,
    				'journal_detail_account_group'      => $get_row->account_group_name,
    				'journal_detail_debit'         => ($get_row->account_name != "PPN KELUARAN"  ? ($get_row->account_name != "Persediaan"  ? ($status == "D" ? trims($total_status_3): 0) : ($status == "D" ? trims($total_status_3) : 0)) : ($status == "D" ? $ppn : 0)),
    				'journal_detail_credit'          => ($status == "K" ? trims($total_status_3) : 0),
    			
    				'journal_detail_description'    => "ROKOK"
    			    ];
    			}
			    	
 			}else{
 			    $detail_data[] = [
    				'journal_detail_trx_id'         => $header_id,
    				'journal_detail_trx_type'       => "RSELL",
    				'journal_detail_header_id'      => $header_id_jr,
    				'journal_detail_account_id'     => $get_row->account_id,
    				'journal_detail_account_number' => $get_row->account_number,
    				'journal_detail_account_name'   => $get_row->account_name,
    				
    				'journal_detail_account_group'      => $get_row->account_group_name,
    				'journal_detail_debit'         => ($get_row->account_name != "PPN KELUARAN"  ? ($get_row->account_name != "Persediaan"  ? ($status == "D" ? trims($sub_total) - $ppn : 0) : ($status == "D" ? (int)trims($hpp) : 0)) : ($status == "D" ? $ppn : 0)),
    				'journal_detail_credit'          =>  ($get_row->account_name != "Kas / Bank"  ? ($get_row->account_name != "Piutang Usaha"  ? ($get_row->account_name != "HPP"  ? ($status == "K" ? trims($sub_total) : 0) : ($status == "K" ? (int)trims($hpp) : 0)) : ($status == "K" ? trims($total_hutang) : 0)) : ($status == "K" ? trims($total_tunai) : 0)),
    			    
    				'journal_detail_description'    => ""
			    ];
 			}
			
		}

		$save_detail = $this->Journals_model->save_detail($detail_data, true);
	}

	public function delete_journal($id)
	{
		$type = "RSELL";
		$delete_header = $this->Journals_model->delete_headerbytrxid($id, $type);

		if ($delete_header) {
			$delete_type = $this->Journals_model->delete_headerbytrxid($id, $type);
		}
	}

	public function update_log($vuedata, $header_id, $date)
	{
		$data_log = [];
		$data_where = [];

		$updateData = array();

		$total_stok = 0;
		$total_stok_rupiah = 0;
		$avg_lg = 0;
		$avg_md = 0;
		$avg_sm = 0;

		foreach ($vuedata as $rowes) {

			$where_1         = array('log_item_id' => $rowes['id']);
			$get_first       = $this->Logs_model->get_data_first($where_1)->result();

			if (count($get_first) > 1) {
				$get_first       = $this->Logs_model->get_data_first($where_1)->row();
				$logs_id         = $get_first->tmslog;

				$total_stok      = $get_first->log_total_stock;
				$total_stok_rupiah = $get_first->log_total_stock_value;

				$avg_lg  = ($get_first->log_average_large_unit);
				$avg_md  = ($get_first->log_average_medium_unit);
				$avg_sm  = ($get_first->log_average_small_unit);

				$log_total_transaction_value = 0;

				$where_2 = array('log_item_id' => $rowes['id'], 'a.timestamp >' => $logs_id);
				$get_data_all_logs_by_item = $this->Logs_model->get_data($where_2, 'a.timestamp asc')->result();

				foreach ($get_data_all_logs_by_item as $row) {


					$total_stok      += $row->log_total_transaction_in_small_unit;

					if ($row->log_type == "BUY" || $row->log_type == "R-SELL") {
						$log_total_transaction_value = (($row->log_large_unit_quantity * ($row->log_large_unit_purchase_price)) + ($row->log_medium_unit_quantity * ($row->log_medium_unit_purchase_price)) + ($row->log_small_unit_quantity * ($row->log_medium_unit_purchase_price)));
					} else {
						$log_total_transaction_value = (($row->log_large_unit_quantity * ($avg_lg)) + ($row->log_medium_unit_quantity * ($avg_md)) + ($row->log_small_unit_quantity * ($avg_sm)));
					}
					$total_stok_rupiah += $log_total_transaction_value;


					$log_average_small_unit  = ($total_stok == 0 ? 0 : ($total_stok_rupiah / $total_stok));
					$log_average_medium_unit = ($log_average_small_unit * $row->medium_unit_contain);
					$log_average_large_unit  = ($log_average_small_unit * $row->large_unit_contain);

					// $log_total_transaction_value = a;

					if ($row->log_type == "BUY" || $row->log_type == "R-SELL") {
						$avg_lg  = ($log_average_large_unit);
						$avg_md  = ($log_average_medium_unit);
						$avg_sm  = ($log_average_small_unit);
						$data_log[] = array(
							'log_id'                        => $row->log_id,
							// 'log_medium_unit_purchase_price' => $medium_purchase_price,
							// 'log_small_unit_purchase_price'  => $small_purchase_price,
							// 'log_total_transaction_value' => $log_total_transaction_value,
							'log_total_stock'             => $total_stok,
							'log_total_stock_value'       => $total_stok_rupiah,
							'log_average_large_unit'      => $log_average_large_unit,
							'log_average_medium_unit'     => $log_average_medium_unit,
							'log_average_small_unit'      => $log_average_small_unit,
							// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
						);
					} else {

						$data_log[] = array(
							'log_id'                         => $row->log_id,
							'log_large_unit_purchase_price'  => $avg_lg,
							'log_medium_unit_purchase_price' => $avg_md,
							'log_small_unit_purchase_price'  => $avg_sm,
							'log_total_transaction_value'    => $log_total_transaction_value,
							'log_total_stock'                => $total_stok,
							'log_total_stock_value'          => $total_stok_rupiah,
							'log_average_large_unit'         => $log_average_large_unit,
							'log_average_medium_unit'        => $log_average_medium_unit,
							'log_average_small_unit'         => $log_average_small_unit,
							// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
						);
					}
				}
			} else {
				return true;
			}
		}

		$after_row_log_update = $this->Logs_model->update_item_batch($data_log);

		return true;
	}

	public function delete()
	{
		$id = $this->input->post('id');
		$data_log = [];
		foreach ($id as $row) {
			$where = array('log_type' => 'R-SELL', 'log_transaction_id' => $row);
			$get_data_log = $this->Logs_model->get_data($where)->result();

			foreach ($get_data_log as $row_list) {

				// Get Data After This Item ID :::
				$where_after = array('log_item_id' => $row_list->log_item_id, 'log_id >' => $row_list->log_id);
				$get_after_data = $this->Logs_model->get_data($where_after)->result();

				if ($get_after_data) {
					foreach ($get_after_data as $row_list_detail) {

						$where_log_delete = array(
							'log_item_id' => $row_list->log_item_id,
							'log_id' => $row_list->log_id
						);

						$delete_logs = $this->Logs_model->delete($where_log_delete);

						// $where_this = array('log_transaction_id' => $row_list_detail->log_transaction_id, 'log_item_id' => $row_list_detail->log_item_id);
						$where_this = array('log_id' => $row_list_detail->log_id, 'log_item_id' => $row_list_detail->log_item_id);
						$log_id = $this->Logs_model->get_data($where_this)->row()->log_id;

						$where_3 = array('log_item_id' => $row_list_detail->log_item_id, 'log_id <' => $log_id);
						$one_line_before_log_data  = $this->Logs_model->get_data_last($where_3)->row_array();
						$one_line_before_total     = 0;
						$one_line_before_log_total = 0;
						$one_line_before_log_avg_large = 0;
						$one_line_before_log_avg_medium = 0;
						$one_line_before_log_avg_small = 0;

						if (!empty($one_line_before_log_data)) {
							$one_line_before_total     = $one_line_before_log_data['log_total_stock'];
							$one_line_before_log_total = $one_line_before_log_data['log_total_stock_value'];
							$one_line_before_log_avg_large = $one_line_before_log_data['log_average_large_unit'];
							$one_line_before_log_avg_medium = $one_line_before_log_data['log_average_medium_unit'];
							$one_line_before_log_avg_small = $one_line_before_log_data['log_average_small_unit'];
						}

						$purchase_price              = $row_list_detail->log_large_unit_purchase_price;
						$log_total_transaction_value = $row_list_detail->log_total_transaction_value;
						$medium_purchase_price       = $row_list_detail->log_medium_unit_purchase_price;
						$small_purchase_price        = $row_list_detail->log_small_unit_purchase_price;
						$log_total_stock             = ($one_line_before_total + $row_list_detail->log_total_transaction_in_small_unit);
						$log_total_stock_value       = ($one_line_before_log_total + $row_list_detail->log_total_transaction_value);
						$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
						$log_average_medium_unit     = ($log_average_small_unit * $row_list_detail->medium_unit_contain);
						$log_average_large_unit      = ($log_average_small_unit * $row_list_detail->large_unit_contain);

						if ($row_list_detail->log_type == 'SELL') {
							$purchase_price              = $one_line_before_log_avg_large;
							// $medium_purchase_price       = ($row_list_detail->log_medium_unit_contain == 0 ? 0 : ($one_line_before_log_avg_large / $row_list_detail->log_medium_unit_contain));
							// $small_purchase_price        = ($row_list_detail->log_small_unit_contain == 0 ? 0 : ($one_line_before_log_avg_large / $row_list_detail->log_large_unit_contain));
							$medium_purchase_price       = ($row_list_detail->log_medium_unit_contain == 0 ? 0 : ($one_line_before_log_avg_medium));
							$small_purchase_price        = ($row_list_detail->log_small_unit_contain == 0 ? 0 : ($one_line_before_log_avg_small));
							$log_total_transaction_value = ($row_list_detail->log_large_unit_quantity * $one_line_before_log_avg_large) + ($row_list_detail->log_medium_unit_quantity * $medium_purchase_price) + ($row_list_detail->log_small_unit_quantity * $small_purchase_price);
							$log_total_stock_value       = ($one_line_before_log_total + $log_total_transaction_value);
							$log_average_small_unit      = ($log_total_stock == 0 ? 0 : ($log_total_stock_value / $log_total_stock));
							$log_average_medium_unit     = ($log_average_small_unit * $row_list_detail->medium_unit_contain);
							$log_average_large_unit      = ($log_average_small_unit * $row_list_detail->large_unit_contain);
						}
						$after_row_data_update = array(
							'log_id'                         => $row_list_detail->log_id,
							'log_large_unit_purchase_price'  => $purchase_price,
							'log_medium_unit_purchase_price' => $medium_purchase_price,
							'log_small_unit_purchase_price'  => $small_purchase_price,
							'log_total_transaction_value'    => $log_total_transaction_value,
							'log_total_stock'                => $log_total_stock,
							'log_total_stock_value'          => $log_total_stock_value,
							'log_average_large_unit'         => $log_average_large_unit,
							'log_average_medium_unit'        => $log_average_medium_unit,
							'log_average_small_unit'         => $log_average_small_unit
						);

						$after_row_where_update = array(
							'log_id' => $row_list_detail->log_id,
						);

						// echo json_encode($one_line_before_log_data);
						$after_row_log_update = $this->Logs_model->update_item($after_row_where_update, $after_row_data_update);
					}
				} else {
					$where_log_delete = array(
						'log_item_id' => $row_list->log_item_id,
						'log_id' => $row_list->log_id
					);

					$delete_logs = $this->Logs_model->delete($where_log_delete);
				}
			}

			$delete_header = $this->Sales_returns_model->delete_header($row);

			if ($delete_header) {
				$delete_type = $this->Sales_returns_model->delete_detail($row);
			}

// 			$id_transfer  = $this->Transfer_model->transfer_detail(array('transaction_id' => $row, 'status' => 'R-SELL'))->row()->header_id;

// 			$tf_delheader = $this->Transfer_model->delete_header($id_transfer);
// 			$tf_deldetail = $this->Transfer_model->delete_detail($id_transfer);

			$id_credit  = $this->Credits_model->credit_header_lite(array('credit_header_retur_id' => $row))->row();

			if ($id_credit != NULL) {
				$db_delheader = $this->Credits_model->delete_headerbyretur($row);
				$db_deldetail = $this->Credits_model->delete_detail($id_credit->id);
			}
			$delete_journal = $this->delete_journal($row);

			// $jr_delheader = $this->Journals_model->delete_headerbytrxid($row, "R-SELL");
			// $jr_deldetail = $this->Journals_model->delete_detailbytrxid($row, "R-SELL");
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out($id)
	{
		$where_header = array('sales_order_header_id' => $id);
		$where_detail = array('sales_order_detail_header_id' => $id);

		$header = $this->Purchase_returns_model->salesorder_header($where_header)->row_array();
		$detail = $this->Purchase_returns_model->salesorder_detail($where_detail)->result();

		$data['content_title'] = 'Print Penjualan';
		$data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/sales_orders/print_out', $data);
	}
}
