<?php
/**
 * Report Profits by Date Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Report_neraca extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Reports_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Neraca';
		$data['date_now'] =  date_now();
		$this->twiggy_display('adm/report_neraca/index', $data);
	}

	public function get_data_detail()
	{	
		$date_1 = $this->input->post("date_1");
		$date_2 = $this->input->post("date_2");

		$dataAktiva  = [];
		$dataLiabilites  = [];
		
        $total_aktiva = 0;
        $total_liabilities = 0;
	
		$get_data_aktiva = $this->Reports_model->get_data_aktiva(change_format_date($date_1), change_format_date($date_2),"")->result();
		$get_data_liabilities = $this->Reports_model->get_data_liabilities(change_format_date($date_1), change_format_date($date_2),"")->result();
				$total_sales   = 0;
		$total_capital = 0;
		$total_return = 0;
		$total_expense = 0;
		$total_gain = 0;
		$total_hpp = 0;
		$total_margin  = 0;
		$total_return_pembelian = 0;
$total_sales_return = 0;
$total_sales_return_pembelian = 0;
$expense = 0;
       
		foreach($get_data_aktiva as $get_row_aktiva)
		{	
		    $dataAktiva[] = array(

			'nama_akun'    => $get_row_aktiva->nama_akun,
			'expense'   => number_format($get_row_aktiva->total),
		    );
		    $total_aktiva += $get_row_aktiva->total;

		}
		foreach($get_data_liabilities as $get_row_liabilities)
		{	
		    $dataLiabilites[] = array(

			'nama_akun'    => $get_row_liabilities->nama_akun,
			'expense'   => number_format(abs($get_row_liabilities->total)),
		    );
		    $total_liabilities += abs($get_row_liabilities->total);

		}
		
		$get_data = $this->Reports_model->get_laba_rugi_penjualan(change_format_date($date_1), change_format_date($date_2),"")->result();
		
    
// 		if($get_data)
// 		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$get_data_return = $this->Reports_model->get_laba_rugi_retur_penjualan(change_format_date($date_1), change_format_date($date_2),"")->result();
				$get_data_return_pembelian = $this->Reports_model->get_laba_rugi_retur_pembelian(change_format_date($date_1), change_format_date($date_2),"")->result();
				$get_data_expense = $this->Reports_model->get_laba_rugi_expense(change_format_date($date_1), change_format_date($date_2))->result();
				$get_data_gain = $this->Reports_model->get_laba_rugi_gain(change_format_date($date_1), change_format_date($date_2))->result();
				$get_data_hpp = $this->Reports_model->get_laba_rugi_hpp(change_format_date($date_1), change_format_date($date_2))->result();
                foreach($get_data_return as $get_row_return)
    			{	
    				$total_sales_return   += $get_row_return->total;
    			}
    			foreach($get_data_return_pembelian as $get_row_return_pembelian)
    			{	
    				$total_sales_return_pembelian   += $get_row_return_pembelian->total;
    			}
    			foreach($get_data_hpp as $get_row_hpp)
    			{	
    			    $dataHpp[] = array(
					'no'      => $no,
					'nama_akun'    => $get_row_hpp->nama_akun,
					'expense'   => number_format($get_row_hpp->total),
				    );
				    $total_hpp += $get_row_hpp->total;

    			}
    			foreach($get_data_expense as $get_row_expense)
    			{	
    			    $dataExpense[] = array(
					'no'      => $no,
					'nama_akun'    => $get_row_expense->nama_akun,
					'expense'   => number_format($get_row_expense->total),
				    );
				    $total_expense += $get_row_expense->total;

    			}
    			foreach($get_data_gain as $get_row_gain)
    			{	
    			    $dataGain[] = array(
					'no'      => $no,
					'nama_akun'    => $get_row_gain->nama_akun,
					'expense'   => number_format($get_row_gain->total),
				    );
				    $total_gain += $get_row_gain->total;

    			}
    			$margin = $get_row->total - $total_sales_return;
				$data[] = array(
					'no'      => $no,
					'date'    => change_format_date($get_row->sales_date, 'd/m/Y'),
					'sales'   => number_format($get_row->total),
				// 	'capital' => number_format($get_row->total_cap),
					'return'    => number_format($total_sales_return),
				// 	'expense'   => number_format($expense),
					'margin'  => number_format($margin),
					'margin_txt'  => ($margin > 0 ? '' : 'bg-danger'),
				);
                $no++;
                // $total_expense += $expense;
				$total_sales   += $get_row->total;
				// $total_capital += $get_row->total_cap;
				$total_return += $total_sales_return;
				$total_return_pembelian += $total_sales_return_pembelian;
				$total_margin  += $margin;
			}
    			
		$response = [
			'dataAktiva'          => $dataAktiva,
			'dataLiabilites'          => $dataLiabilites,
			'total_aktiva' => number_format($total_aktiva),
			'total_liabilities'  => number_format(abs($total_liabilities) + (($total_margin - $total_hpp) - $total_expense + $total_gain)),
			'total_laba_sebelum_pajak' => number_format((($total_margin - $total_hpp) - $total_expense + $total_gain)),
		];

		// $this->session->set_userdata('date_1', $date_1);
		// $this->session->set_userdata('date_2', $date_2);
		// $this->session->set_userdata('total_income', $total_income);

		output_json($response);
	}

}

?>
