<?php

/**
 * Report Purchase Orders Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use libraries\BaseController;

class Report_general_ledgers extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Journals_model');
		$this->load->model('Accounts_model');
		$this->load->model('Suppliers_model');
		$this->load->model('Items_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title'] = 'Laporan Buku Besar';
		$data['account_data'] = $this->Accounts_model->get_data()->result();
		$data['item_data']     = $this->Items_model->get_data()->result();

		$this->twiggy_display('adm/report_general_ledgers/index', $data);
	}

	public function get_data_detail()
	{
		$account  = $this->input->post("account");
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");

		$data  = [];
		$where = [];
		// $order = ("journal_header_date ASC, journal_header_number");
		$order = ("journal_detail_account_number ASC");

		if (isset($account) && $account != '' && $account != '(Semua)') {
			$where['journal_detail_account_id'] = $account;
		}
		if (isset($fromdate) && $fromdate != '') {
			$where['journal_header_date >='] = change_format_date($fromdate);
		}
		if (isset($todate) && $todate != '') {
			$where['journal_header_date <='] = change_format_date($todate);
		}



		$get_data = $this->Journals_model->journal_detail_advance(false, $where, $order, 'journal_detail_account_id')->result();

		// echo json_encode($get_data);
		// die();

		$grand_total_debit    = 0;
		$grand_total_credit    = 0;

		// ketika data tersedia
		// maka generate data json untuk Datatable
		$saldo = 0;
		$line = 1;
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $k => $get_row) {

				// $a = 0;
				// $purchase_total = $get_row->journal_header_sub_total;
				// if (isset($item) && $item != '' && $item != '(Semua)') {
				// 	$purchase_total = $a += $get_row->journal_detail_total;
				// }
				$where['journal_detail_account_id'] = $get_row->journal_detail_account_id;

				// $sum_data = $this->Journals_model->journal_detail_advance(true, array('journal_detail_account_id' => $get_row->journal_detail_account_id, 'journal_header_date' < change_format_date($fromdate)))->row();
				// $saldo = 0;
				$sum_data = $this->Journals_model->journal_detail_advance(true, array('journal_detail_account_id' => $get_row->journal_detail_account_id, 'journal_header_date <' => change_format_date($fromdate)))->row();
				$saldo = ($sum_data->ttl_debit - $sum_data->ttl_credit);

				$data[] = array(
					'no'             => $no,
					'number'         => $get_row->account_header_number . $get_row->account_header_child_number . $get_row->account_number,
					'name'           => $get_row->account_name,
					'transaction_number'         => $get_row->journal_header_description,
					'normal_balance'           => $get_row->normal_balance,
					// 'normal_balance' => $saldo,
				);




				$gdata_detail = $this->Journals_model->journal_detail_advance(false, $where, 'journal_detail_id asc')->result();


				$rowspan = 1;
				$no = 1;
				foreach ($gdata_detail as $key => $value) {
					$saldo_hitung = 0;
					// if ($no == 1) {
					// 	$saldo_hitung = $saldo;
					// } else {
					$saldo_hitung = $saldo += $value->journal_detail_debit - $value->journal_detail_credit;
					// }

					$data[$k]['detail'][$key] = array(
						'no'             => $no,
						'detail_rowspan' => $rowspan,
						'detail_line'    => $line,
						'date' => change_format_date($value->journal_header_date, 'd/m/Y'),
						'journal_number' => $value->journal_header_number,
						'account_number' => $value->journal_detail_account_number,
						'account_name'   => $value->journal_detail_account_name,
						'description'    => $value->journal_header_description,
						'debit'          => number_format($value->journal_detail_debit),
						'credit'         => number_format($value->journal_detail_credit),
						'saldo'          => number_format($saldo_hitung),
					);
					$no++;
					$rowspan++;
					$line++;

					$grand_total_debit += $value->journal_detail_debit;
					$grand_total_credit += $value->journal_detail_credit;
					// $total_all_tunai    += $tunai;
					// $total_all_transfer += $transfer;
					// $total_all_method   += $t_all;

				}
			}
		}

		$this->session->set_userdata('account', $account);

		$this->session->set_userdata('fromdate', $fromdate);
		$this->session->set_userdata('todate', $todate);

		$fromdate_text = ($fromdate == '' ? '' : change_format_date($fromdate, 'd/m/Y'));
		$todate_text   = ($todate == '' ? '' : change_format_date($todate, 'd/m/Y'));
		$date_show = $fromdate_text . ' - ' . $todate_text;

		$response = [
			'date'               => $date_show,
			'detail_data'        => $data,
			'grand_total_debit'  => number_format($grand_total_debit),
			'grand_total_credit' => number_format($grand_total_credit),
			'total_transaksi'    => number_format(count($get_data))
		];

		output_json($response);
	}

	public function export_excel()
	{

		$supplier = $this->session->userdata('supplier');
		$ppn      = $this->session->userdata('ppn');
		$item     = $this->session->userdata('item');
		$fromdate = $this->session->userdata('fromdate');
		$todate   = $this->session->userdata('todate');

		$where    = [];
		$order = ("journal_header_date ASC, journal_header_number");
		$supplier_name = '-';
		$item_name = '-';

		$fromdate_text = ($fromdate == '' ? '-' : change_format_date($fromdate, 'd/m/Y'));
		$todate_text   = ($todate == '' ? '-' : change_format_date($todate, 'd/m/Y'));

		if (isset($supplier) && $supplier != '' && $supplier != '(Semua)') {
			$where['journal_header_supplier_id'] = $supplier;
			$supplier_name = $this->Suppliers_model->get_data(array('supplier_id' => $supplier))->row()->supplier_name;
		}
		if (isset($item) && $item != '' && $item != '(Semua)') {
			$where['journal_detail_item_id'] = $item;
			$item_name = $this->Items_model->get_data(array('item_id' => $item))->row()->item_name;
		}
		if (isset($ppn) && $ppn != '' && $ppn != '(Semua)') {
			$where['c.ppn_status'] = $ppn;
		}
		if (isset($fromdate) && $fromdate != '') {
			$where['journal_header_date >='] = change_format_date($fromdate);
		}
		if (isset($todate) && $todate != '') {
			$where['journal_header_date <='] = change_format_date($todate);
		}

		$get_data = $this->Journals_model->purchaseorder_detail_advance($where, $order)->result();

		// Class PHPExcel
		$excel = new PHPExcel();
		// Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
			->setLastModifiedBy('TOKO TEST INDONESIA')
			->setTitle("PEMBELIAN")
			->setSubject("PEMBELIAN")
			->setDescription("PEMBELIAN")
			->setKeywords("PEMBELIAN");

		// Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
			),
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
				'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
			),
			'borders' => array(
				'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
				'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
				'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
				'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

		// Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
				'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
			),
			'borders' => array(
				'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		$excel->setActiveSheetIndex(0)->setCellValue('A1', "Pembelian");
		$excel->getActiveSheet()->mergeCells('A1:Q1');
		$excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
		$excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
		$excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Supplier");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": " . $supplier_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Nama Barang");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": " . $item_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A5', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B5', ": " . $fromdate_text . " - " . $todate_text);

		$excel->getActiveSheet()->mergeCells('A7:A8');
		$excel->getActiveSheet()->mergeCells('B7:B8');
		$excel->getActiveSheet()->mergeCells('C7:C8');
		$excel->getActiveSheet()->mergeCells('D7:D8');
		$excel->getActiveSheet()->mergeCells('E7:E8');

		$excel->getActiveSheet()->mergeCells('F7:H7');
		$excel->getActiveSheet()->mergeCells('I7:K7');
		$excel->getActiveSheet()->mergeCells('L7:N7');

		$excel->getActiveSheet()->mergeCells('O7:O8');
		$excel->getActiveSheet()->mergeCells('P7:P8');
		$excel->getActiveSheet()->mergeCells('Q7:Q8');

		$excel->setActiveSheetIndex(0)->setCellValue('A7', "No.");
		$excel->setActiveSheetIndex(0)->setCellValue('B7', "Nomor Pembelian");
		$excel->setActiveSheetIndex(0)->setCellValue('C7', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('D7', "Supplier");
		$excel->setActiveSheetIndex(0)->setCellValue('E7', "Nama Barang");
		$excel->setActiveSheetIndex(0)->setCellValue('F7', "Satuan Besar");
		$excel->setActiveSheetIndex(0)->setCellValue('I7', "Satuan Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('L7', "Satuan Kecil");

		$excel->setActiveSheetIndex(0)->setCellValue('F8', "Satuan");
		$excel->setActiveSheetIndex(0)->setCellValue('G8', "Quantity");
		$excel->setActiveSheetIndex(0)->setCellValue('H8', "Harga");
		$excel->setActiveSheetIndex(0)->setCellValue('I8', "Satuan");
		$excel->setActiveSheetIndex(0)->setCellValue('J8', "Quantity");
		$excel->setActiveSheetIndex(0)->setCellValue('K8', "Harga");
		$excel->setActiveSheetIndex(0)->setCellValue('L8', "Satuan");
		$excel->setActiveSheetIndex(0)->setCellValue('M8', "Quantity");
		$excel->setActiveSheetIndex(0)->setCellValue('N8', "Harga");

		$excel->setActiveSheetIndex(0)->setCellValue('O7', "Discount(%)");
		$excel->setActiveSheetIndex(0)->setCellValue('P7', "Total");
		$excel->setActiveSheetIndex(0)->setCellValue('Q7', "Status");

		// Apply style header
		$excel->getActiveSheet()->getStyle('A7:A8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('B7:B8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('C7:C8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('D7:D8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('E7:E8')->applyFromArray($style_col);

		$excel->getActiveSheet()->getStyle('F7:H7')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('I7:K7')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('L7:N7')->applyFromArray($style_col);

		$excel->getActiveSheet()->getStyle('F8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('G8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('H8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('I8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('J8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('K8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('L8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('M8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('N8')->applyFromArray($style_col);

		$excel->getActiveSheet()->getStyle('O7:O8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('P7:P8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('Q7:Q8')->applyFromArray($style_col);


		$no = 0; // Untuk penomoran tabel, di awal set dengan 1
		$numrow = 9; // Set baris pertama untuk isi tabel adalah baris ke 9
		$numtrx = '';
		foreach ($get_data as $get_row) { // Lakukan looping pada variabel row

			$ppn_status = '';
			$get_item   = $this->Items_model->get_data(array('item_id' => $get_row->item_id))->row();
			if ($get_item) {
				$ppn_status = $get_item->ppn_status;
			}

			$ppn_percentage = 0;
			$ppn_total = 0;
			if ($ppn_status == 2) {
				$ppn_percentage = $get_row->journal_header_ppn_percentage;
				$ppn_total = ($get_row->journal_detail_total * $ppn_percentage) / 100;
			}

			if ($numtrx != $get_row->journal_header_number) {
				$no++;
			}
			$numtrx = $get_row->journal_header_number;

			$excel->setActiveSheetIndex(0)->setCellValue('A' . $numrow, $no);
			$excel->setActiveSheetIndex(0)->setCellValue('B' . $numrow, $get_row->journal_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('C' . $numrow, change_format_date($get_row->journal_header_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('D' . $numrow, $get_row->supplier_name);
			$excel->setActiveSheetIndex(0)->setCellValue('E' . $numrow, $get_row->journal_detail_item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('F' . $numrow, ($get_row->journal_detail_large_unit_quantity  > 0 ? $get_row->journal_detail_large_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('G' . $numrow, ($get_row->journal_detail_large_unit_quantity  > 0 ? to_decimal($get_row->journal_detail_large_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('H' . $numrow, ($get_row->journal_detail_large_unit_quantity  > 0 ? ($get_row->journal_detail_large_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('I' . $numrow, ($get_row->journal_detail_medium_unit_quantity > 0 ? $get_row->journal_detail_medium_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('J' . $numrow, ($get_row->journal_detail_medium_unit_quantity > 0 ? to_decimal($get_row->journal_detail_medium_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('K' . $numrow, ($get_row->journal_detail_medium_unit_quantity > 0 ? ($get_row->journal_detail_medium_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('L' . $numrow, ($get_row->journal_detail_small_unit_quantity  > 0 ? $get_row->journal_detail_small_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('M' . $numrow, ($get_row->journal_detail_small_unit_quantity  > 0 ? to_decimal($get_row->journal_detail_small_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('N' . $numrow, ($get_row->journal_detail_small_unit_quantity  > 0 ? ($get_row->journal_detail_small_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('O' . $numrow, number_format($get_row->journal_detail_discount_percentage) . '%');
			$excel->setActiveSheetIndex(0)->setCellValue('P' . $numrow, ($get_row->journal_detail_total));
			// $excel->setActiveSheetIndex(0)->setCellValue('O'.$numrow, number_format($get_row->journal_detail_total + $ppn_total));
			$excel->setActiveSheetIndex(0)->setCellValue('Q' . $numrow, number_format($ppn_status));

			// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			$excel->getActiveSheet()->getStyle('A' . $numrow . ':Q' . $numrow)->applyFromArray($style_row);
			$excel->getActiveSheet()->getStyle('H' . $numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('K' . $numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('L' . $numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('O' . $numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('P' . $numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

			// Tambah 1 setiap kali looping
			$numrow++; // Tambah 1 setiap kali looping
		}

		// Set width
		$excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

		// Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);

		// Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);

		// Set judul file excel
		$excel->getActiveSheet(0)->setTitle("PEMBELIAN");
		$excel->setActiveSheetIndex(0);

		// Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PEMBELIAN_' . $date_now . '.xlsx';

		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment; filename="' . $filename . '"'); // Set nama file excel nya
		header('Cache-Control: max-age=0');
		$write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
		$write->save('php://output');
	}
}
