/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.report_courrier = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elDate_1: '.date_1',
		elDate_2: '.date_2',
		status_select: '#status-select',

		urlRequestDataSales: window.APP.siteUrl + 'adm/report_courrier/get_data',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					elDate_1: '',
					elDate_2: '',
					date_1: '',
					date_2: '',
					pembelian: false,
					rekap_barang: false,
					rekap_tipe: false,
					rekap_grup: false,
					totalIncome: 0,
					detailData: []
				},
				methods: {
					getData: function (val) {
						var vue = this;

						var val_date_1 = $(that.elDate_1).val();
						var val_date_2 = $(that.elDate_2).val();

						var val_status = $(that.status_select).val();

						$.ajax({
							url: that.urlRequestDataSales,
							type: 'post',
							data: {
								'date_1'  : val_date_1,
								'date_2'  : val_date_2,
								'status': val_status
							},
							dataType: "json",
							beforeSend : function() {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
							success: function (response) {

								vue.$set(vue, 'detailData', response['data']);

								vue.$set(vue, 'date_1', response['date_1']);
								vue.$set(vue, 'date_2', response['date_2']);
								// vue.$set(vue, 'totalIncome', response['total_income']);

								$(that.elVue).unblock();
							}
						});
					},

					exportExcel: function () {
						var vue = this;
						vue.getData();

						setTimeout(function () {
							window.location = window.APP.siteUrl + 'adm/report_courrier_ppn/export_excel_income';
						}, 500);
					}
				},
				mounted: function () {

				}
			});

		},

	}

})(jQuery);