<?php

/**
 * Purchase Orders Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Purchase_model extends Model
{
    
    public function purchase_autonumber()
	{	
		$sql = $this->db;

		$sql->select('RIGHT(purchase_header.number, 4) as serial_number', FALSE);
		$sql->where('MONTH(date) = MONTH(CURRENT_DATE())');
		// $sql->where('SUBSTR(purchase_order_headers.purchase_order_header_number, 1, 2) = "'.$supp_code.'"');
		$sql->order_by('number', 'DESC');
		$sql->limit(1);    
		$query = $sql->get('purchase_header');  
		if($query->num_rows() <> 0){         
			$data = $query->row();      
			$serial_number = intval($data->serial_number) + 1;    
		}
		else {          
			$serial_number = 01;    
		}

		$serial_number_generate = str_pad($serial_number, 4, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function purchase_header($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('purchase_header a');
		// $sql->join('master_customers b', 'b.customer_id = a.customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchase_detail($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, a.item_code as it_code, a.item_name as it_name');
		$sql->from('purchase_detail a');
		$sql->join('master_items b', 'b.item_id = a.item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('purchase_header', $data);
		}

		return $this->db->insert('purchase_header', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('purchase_detail', $data);
		}

		return $this->db->insert('purchase_detail', $data);
	}

	public function update_header($id, $data)
	{
		$this->db->where('id', $id);
		return $this->db->update('purchase_header', $data);
	}

	public function update_master_item_batch($data)
	{
		return $this->db->update_batch('master_items', $data, 'item_id');
	}

	public function delete_header($id)
	{
		$this->db->where("id", $id);
		return $this->db->delete("purchase_header");
	}

	public function delete_detail($id)
	{
		$this->db->where("header_id", $id);
		return $this->db->delete("purchase_detail");
	}

	public function delete_detail_advance($where)
	{
		$this->db->where($where);
		return $this->db->delete("purchase_detail");
	}
}
