<?php

/**
 * Categories Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Categories_model extends Model
{

	public function get_data($where = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_categories');
		$sql->order_by('category');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data)
	{
		return $this->db->insert('master_categories', $data);
	}

	public function update($id, $data)
	{
		$this->db->where('categories_id', $id);
		return $this->db->update('master_categories', $data);
	}

	public function delete($id)
	{
		$this->db->where('categories_id', $id);
		return $this->db->delete('master_categories');
	}

	public function check_id($where)
	{
		$this->db->select("*");
		$this->db->from('master_categories');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}
}
