<?php

/**
 * Utang Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
require_once APPPATH."libraries/BaseController.php";
include APPPATH.'third_party/PHPExcel/PHPExcel.php';
include APPPATH.'third_party/PHPExcel/PHPExcel/IOFactory.php';
use libraries\BaseController;

class Utang extends BaseController
{

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Utang_model');
		$this->load->model('Suppliers_model');
	}

	public function index()
	{
		$data['content_title'] = 'Utang';

		$this->twiggy_display('adm/utang/index', $data);
	}
	
	public function get_data()
	{
		$data = [];

		$get_data = $this->Utang_model->get_data()->result();

		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'            => $no,
					'id'            => $get_row->id_utang,
					'id_supplier'          => $get_row->supplier_name,
					'total_utang'        => number_format($get_row->total_utang),
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}
	
	public function edit($id = 'new')
	{
		$title       = "Tambah";
		$get_data    = array();
		$utang = 0;
		if ($id != 'new') {
			$title    = "Edit";
			$where         = array('item_id' => $id);
			$get_data      = $this->Utang_model->get_data($where)->row_array();
			$utang   = number_format(check_array_key($get_data, 'total_utang'));

		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;
		$data['total_utang'] 	= $utang;
		$data['supplier']    = $this->Suppliers_model->get_data()->result();

		$this->twiggy_display('adm/utang/edit', $data);
	}

	public function save()
	{
		// post
		$id            = $this->input->post('id');
		$id_supplier          = $this->input->post('id_supplier');
		$total_utang          = $this->input->post('total_utang');
		

		$action                          = $this->input->post('action');


		$data_save = array(
// 			'id_utang'                       => $id ,
			'id_supplier'                       =>$id_supplier,
			'tanggal_utang'         => "",
			'total_utang'                     => trims($total_utang)  ,
		
		);

		if ($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Utang_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Utang_model->update($id, $data_save);
		}

		if ($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'TES menyimpan data',
				'id'      => $convert
			);
		} else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}




	public function delete()
	{
		$id = $this->input->post('id');

		foreach ($id as $row) {
			$delete_type = $this->Utang_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

}
