<?php

/**
 * Items Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
require_once APPPATH."libraries/BaseController.php";
include APPPATH.'third_party/PHPExcel/PHPExcel.php';
include APPPATH.'third_party/PHPExcel/PHPExcel/IOFactory.php';
use libraries\BaseController;

class Items extends BaseController
{

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Items_model');
		$this->load->model('Groups_model');
		$this->load->model('Pabrik_model');
		$this->load->model('Colors_model');
		$this->load->model('Categories_model');
		$this->load->model('Report_stock_model');
		
		$this->load->model('Sizes_model');
		$this->load->model('Units_model');
	}

	public function index()
	{
		$data['content_title'] = 'Barang';

		$this->twiggy_display('adm/items/index', $data);
	}
	public function gudang()
	{
		$data['content_title'] = 'Barang';

		$this->twiggy_display('adm/items/index2', $data);
	}

	public function get_data()
	{
		$data = [];

		$get_data = $this->Items_model->get_data()->result();
		if (logged_user('role') != 1) {
		  //  array('division' => logged_user('division'))
			$get_data = $this->Items_model->get_data()->result();
		}

		if ($get_data) {
			$no = 1;
			$updateStock = $this->Items_model->updateStock();
			foreach ($get_data as $get_row) {
				$lg_unit = ($get_row->large_unit_contain == "0.00" ? "" : to_decimal($get_row->large_unit_contain));

				$unit = rtrim($get_row->large_unit . " " . $lg_unit);
				$ppn_status = '-';
				if ($get_row->ppn_status == '2') {
					$ppn_status = "<span class='badge badge-success' style='width:100px;'>2</span>";
				} elseif ($get_row->ppn_status == '1') {
					$ppn_status = "<span class='badge badge-secondary' style='width:100px;'>1</span>";
				} else {
					$ppn_status = "<span class='badge badge-warning' style='width:100px;'>3</span>";
				}

				$minimum_stock = "<span class='badge badge-danger' style='width:100px;'>" . to_decimal($get_row->minimum_stock) . " " . $get_row->large_unit . "</span>";
				$bgcolor = ($get_row->mobile_active == "1" ? "bg-info" : "");
				$bgcolorweb = ($get_row->web_active == "1" ? "bg-danger" : "");
				// $where = array('a.item_id' => $get_row->item_id);
		  //      $where2 = array('a.purchase_order_detail_item_id' => $get_row->item_id);
		  //      $where_so = array('a.selling_order_detail_item_id' => $get_row->item_id);
				// $get_po = $this->Report_stock_model->get_purchase_detail($where2, '', 'a.purchase_order_detail_item_id')->row();
    // 			$get_so = $this->Report_stock_model->get_selling_order_details($where_so, '', 'a.selling_order_detail_item_id')->row();
    // 			$get_st = $this->Report_stock_model->get_stock_detail($where, '', 'a.item_id')->row();
    
    // 			$stock_po = 0;
    // 			$stock_so = 0;
    // 			$stock_st = 0;
    
    // 			if ($get_po) {
    // 				$stock_po = $get_po->s_quantity;
    // 			}
    
    // 			if ($get_so) {
    // 				$stock_so = $get_so->s_quantity;
    // 			}
    
    // 			if ($get_st) {
    // 				$stock_st = $get_st->s_quantity;
    // 			}
                // $stock = "<span class='badge badge-danger ' style='width:100px;'>" .rtrim( $total_large . ", "  . $total_medium . "," . $total_small, ", ") . "</span>";
                
				$data[] = array(
					'no'            => $no,
					'id'            => $get_row->item_id,
					'code'          => $get_row->item_code,
					'name'          => $get_row->item_name,
					'grup'          => $get_row->group_name,
					'categories'          => $get_row->category,
					'pabrik'          => $get_row->nama_pabrik,
					'stock' => $get_row->stok_pos + $get_row->stok_awal." ".$get_row->large_unit,
					'unit'          => $get_row->large_unit,
					'price'         => number_format($get_row->last_selling_price_large_unit),
					'price2'         => number_format($get_row->last_selling_price_large_unit2),
					'purchase_price'         => number_format($get_row->last_selling_price_large_unit3),
					'minimum_stock' => $minimum_stock,
					'ppn_status'    => $ppn_status,
					'mobile_active' => $get_row->mobile_active,
					'web_active'    => $get_row->web_active,
					'bgcolor'       => $bgcolor,
					'bgcolorweb'    => $bgcolorweb,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}
	
	public function get_data2()
	{
		$data = [];

		$get_data = $this->Items_model->get_data()->result();
		if (logged_user('role') != 1) {
		  //  array('division' => logged_user('division'))
			$get_data = $this->Items_model->get_data()->result();
		}

		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$lg_unit = ($get_row->large_unit_contain == "0.00" ? "" : to_decimal($get_row->large_unit_contain));
				$md_unit = ($get_row->medium_unit_contain == "0.00" ? "" : to_decimal($get_row->medium_unit_contain));
				$sm_unit = ($get_row->small_unit_contain == "0.00" ? "" : to_decimal($get_row->small_unit_contain));

				$unit = rtrim($get_row->large_unit . " " . $lg_unit . ", " . $get_row->medium_unit . " " . $md_unit . ", " . $get_row->small_unit . " " . $sm_unit, ", ");
				$ppn_status = '-';
				if ($get_row->ppn_status == '2') {
					$ppn_status = "<span class='badge badge-success' style='width:100px;'>2</span>";
				} elseif ($get_row->ppn_status == '1') {
					$ppn_status = "<span class='badge badge-secondary' style='width:100px;'>1</span>";
				} else {
					$ppn_status = "<span class='badge badge-warning' style='width:100px;'>3</span>";
				}

				$minimum_stock = "<span class='badge badge-danger' style='width:100px;'>" . to_decimal($get_row->minimum_stock) . " " . $get_row->large_unit . "</span>";
				$bgcolor = ($get_row->mobile_active == "1" ? "bg-info" : "");
				$bgcolorweb = ($get_row->web_active == "1" ? "bg-danger" : "");
//                 $where = array('item_id' => $get_row->item_id);
// 		    $where_so = array('selling_order_detail_item_id' => $get_row->item_id);
//             $get_po = $this->Report_stock_model->get_purchase_detail_lite($where, '', 'item_id')->row();
// 			$get_so = $this->Report_stock_model->get_sales_detail_lite($where_so, '', 'selling_order_detail_item_id')->row();
// 			$get_st = $this->Report_stock_model->get_stock_detail_lite($where, '', 'item_id')->row();

// 			$stock_po = 0;
// 			$stock_so = 0;
// 			$stock_st = 0;

// 			if ($get_po) {
// 				$stock_po = $get_po->s_quantity;
// 			}

// 			if ($get_so) {
// 				$stock_so = $get_so->s_quantity;
// 			}

// 			if ($get_st) {
// 				$stock_st = $get_st->s_quantity;
// 			}

				$data[] = array(
					'no'            => $no,
					'id'            => $get_row->item_id,
					'code'          => $get_row->item_code,
					'name'          => $get_row->item_name,
				// 	'stock'            => $stock_po + $stock_st - $stock_so,
					'price'         => number_format($get_row->last_selling_price_large_unit),
					
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function get_data_group_child()
	{
		$id = $this->input->post('id');

		$where  = array('a.group_id' => $id);
		$result = $this->Groups_model->get_data_child($where)->result();

		echo json_encode($result);
	}

	public function edit($id = 'new')
	{
		$title       = "Tambah";
		$get_data    = array();
		$minimum_stock  = 0;
		$lg_contain  = 0;
		$lg_selling  = 0;
		$lg_selling2  = 0;
		$lg_selling3  = 0;
		$lg_purchase = 0;
		$desc = '';

		if ($id != 'new') {
			$title    = "Edit";
			$where         = array('item_id' => $id);
			$get_data      = $this->Items_model->get_data($where)->row_array();
			$minimum_stock = to_decimal(check_array_key($get_data, 'minimum_stock'));
			$lg_contain    = to_decimal(check_array_key($get_data, 'large_unit_contain'));
			$lg_purchase   = number_format(check_array_key($get_data, 'last_purchase_price_large_unit'));
			$lg_selling    = number_format(check_array_key($get_data, 'last_selling_price_large_unit'));
			$lg_selling2    = number_format(check_array_key($get_data, 'last_selling_price_large_unit2'));
			$lg_selling3    = number_format(check_array_key($get_data, 'last_selling_price_large_unit3'));
		
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;
		$data['group_data']    = $this->Groups_model->get_data()->result();
		$data['category_data']    = $this->Categories_model->get_data()->result();
		$data['pabrik_data']     = $this->Pabrik_model->get_data()->result();
// 		$data['color_data']    = $this->Colors_model->get_data()->result();
// 		$data['size_data']     = $this->Sizes_model->get_data()->result();
		$data['unit_data']     = $this->Units_model->get_data()->result();

		$data['minimum_stock'] 	= $minimum_stock;
		$data['lg_contain'] 	= $lg_contain;
		$data['lg_purchase'] 	= $lg_purchase;
		$data['lg_selling'] 	= $lg_selling;
		$data['lg_selling2'] 	= $lg_selling2;
		$data['lg_selling3'] 	= $lg_selling3;
	

// 		$data['description'] 	= $desc;
// 		$data['img_file_dir'] 	= base_url('assets/images/upload_file/items/') . $img_file;

		$this->twiggy_display('adm/items/edit', $data);
	}


	public function set_operational()
	{
		$id = $this->input->post('id');

		$delete_type = $this->Items_model->update_operational(array('mobile_active' => $id));

		$response = array(
			'message' => 'Berhasil mengubah data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function set_show()
	{
		$id = $this->input->post('id');

		$delete_type = $this->Items_model->update_conf(1, array('status' => $id));

		$response = array(
			'message' => 'Berhasil menampilkan data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function save()
	{
		// post
		$id            = $this->input->post('id');
		$code          = $this->input->post('no_obat');
		$name          = $this->input->post('name');
		$minimum_stock = $this->input->post('minimum_stock');
		$category         = $this->input->post('category');
		$group         = $this->input->post('group');
		$pabrik          = $this->input->post('pabrik');
		$large_unit                      = $this->input->post('large_unit');
		$large_unit_contain              = $this->input->post('large_unit_contain');
		$last_purchase_price_large_unit  = $this->input->post('last_purchase_price_large_unit');
		$last_selling_price_large_unit   = $this->input->post('last_selling_price_large_unit');
		$last_selling_price_large_unit2   = $this->input->post('last_selling_price_large_unit2');
		$last_selling_price_large_unit3   = $this->input->post('last_selling_price_large_unit3');
		$action                          = $this->input->post('action');


		$path = './assets/images/upload_file/items/';
		$item_picture_name = 'item_picture_name';
		$filename = 'default.jpg';
		$allowedTypes = 'jpg|jpeg|png|JPG';

		if (!empty($_FILES['item_picture_name']['name'])) {
			$filename = $_FILES['item_picture_name']['name'];
			upload_file($path, trims($item_picture_name), null, $allowedTypes);
		}

		if ($filename == 'default.jpg' && !empty($old_img)) {
			$filename = $old_img;
		}

		if (isset($medium_unit) && $medium_unit != "" && $medium_unit_contain > 0 && $last_purchase_price_large_unit > 0) {
			$last_purchase_price_medium_unit = (trims($last_purchase_price_large_unit) / trims($large_unit_contain));
		}

		if (isset($small_unit) && $small_unit != "" && $small_unit_contain > 0 && $last_purchase_price_small_unit > 0) {
			$last_purchase_price_small_unit = (trims($last_purchase_price_medium_unit) / trims($medium_unit_contain));
		}

		$data_save = array(
			'item_code'                       => $code,
			'item_name'                       => $name,
			'item_group_id'                   => $group,
			'obat_category_id'                   => $category,
			'obat_pabrik_id'                    => $pabrik,
			'large_unit'                      => $large_unit,
			'large_unit_contain'              => $large_unit_contain,
			'last_purchase_price_large_unit'  => trims($last_purchase_price_large_unit),
			'last_selling_price_large_unit'   => trims($last_selling_price_large_unit),
            'last_selling_price_large_unit2'   => trims($last_selling_price_large_unit2),
            'last_selling_price_large_unit3'   => trims($last_selling_price_large_unit3),
            'minimum_stock'     => $minimum_stock,
		);
        
		if ($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Items_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Items_model->update($id, $data_save);
		}

		if ($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		} else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function save_grouping_quantity()
	{
		$id         = $this->input->post('id');
		$number     = $this->input->post("number");
		$date       = $this->input->post("date");
		$supplier   = $this->input->post("supplier");
		$description  = $this->input->post("description");

		$vuedata = $this->input->post('vuedata');
		$header_id   = $id;

		echo json_encode($vuedata);
		$response = [
			'message' => 'success',
			'status'  => 'success',
			'id'      => 'success'
		];
		output_json($response);
		die();
		$header_data = [
			'purchase_order_header_number'        => $number,
			'purchase_order_header_date'          => change_format_date($date),
			'purchase_order_header_supplier_id'   => $supplier,
			'purchase_order_header_description'   => $description
		];

		$detail_data = [];

		// if save $id = new else update data
		if ($id == "new") {
			// save header
			$save_header = $this->Purchase_orders_model->save_header($header_data);
			if ($save_header) {
				$header_id = $this->db->insert_id();
				foreach ($vuedata as $row) {
					$detail_data[] = [
						'purchase_order_detail_header_id'      => $header_id,
						'purchase_order_detail_material_id'    => $row['id'],
						'purchase_order_detail_material_name'  => $row['name'],
						'purchase_order_detail_unit_id'        => $row['unit_id'],
						'purchase_order_detail_quantity'       => $row['quantity'],
						'purchase_order_detail_remark'         => $row['remark'],
					];
				}

				$save_detail = $this->Purchase_orders_model->save_detail($detail_data, true);

				if ($save_detail) {
					$msg    = "Berhasil menyimpan data";
					$status = "success";
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		} else {

			$delete_detail = $this->Purchase_orders_model->delete_detail($id);

			if ($delete_detail) {
				$save_header = $this->Purchase_orders_model->update_header($id, $header_data);

				if ($save_header) {
					// $header_id = $this->db->insert_id();
					foreach ($vuedata as $row) {
						$detail_data[] = [
							'purchase_order_detail_header_id'      => $header_id,
							'purchase_order_detail_material_id'    => $row['id'],
							'purchase_order_detail_material_name'  => $row['name'],
							'purchase_order_detail_unit_id'        => $row['unit_id'],
							'purchase_order_detail_quantity'       => $row['quantity'],
							'purchase_order_detail_remark'         => $row['remark'],
						];
					}

					$save_detail = $this->Purchase_orders_model->save_detail($detail_data, true);

					if ($save_detail) {
						$msg    = "Berhasil menyimpan data";
						$status = "success";
					} else {
						$msg    = "Gagal menyimpan data";
						$status = "error";
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);
	}


	public function delete()
	{
		$id = $this->input->post('id');

		foreach ($id as $row) {
			$delete_type = $this->Items_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function show_item_on_mobile()
	{
		$id = $this->input->post('id');
		$data = $this->input->post('data');

		$is_active = ($data == "0" ? "1" : "0");
		$msg = ($data == "0" ? "Berhasil menampilkan barang pada Mobile Apps" : "Berhasil menyembunyikan barang dari Mobile Apps");
		$data = array(
			'mobile_active' => $is_active,
		);
		$update = $this->Items_model->update($id, $data);

		$response = array(
			'message' => $msg,
			'status'  => 'success'
		);

		output_json($response);
	}

	public function show_item_on_web()
	{
		$id = $this->input->post('id');
		$data = $this->input->post('data');

		$is_active = ($data == "0" ? "1" : "0");
		$msg = ($data == "0" ? "Berhasil menampilkan barang pada Web Apps" : "Berhasil menyembunyikan barang dari Web Apps");
		$data = array(
			'web_active' => $is_active,
		);
		$update = $this->Items_model->update($id, $data);

		$response = array(
			'message' => $msg,
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id()
	{
		$username  = $this->input->post('id');
		$where     = array('item_code' => $username);

		$check = $this->Items_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}
	public function check_name()
	{
		$username  = $this->input->post('id');
		$where     = array('item_name' => $username);

		$check = $this->Items_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}
	
	public function export_excel() {

		
		$id = $this->input->post('id');

		// Class PHPExcel
		$excel = new PHPExcel();
		// Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("PENJUALAN")
							   ->setSubject("PENJUALAN")
							   ->setDescription("PENJUALAN")
							   ->setKeywords("PENJUALAN");


		$excel->setActiveSheetIndex(0)->setCellValue('A1', "kode");
		$excel->setActiveSheetIndex(0)->setCellValue('B1', "nama");
		$excel->setActiveSheetIndex(0)->setCellValue('C1', "harga");
		$excel->setActiveSheetIndex(0)->setCellValue('D1', "harga_beli");


	

		$no = 1; // Untuk penomoran tabel, di awal set dengan 1
		
		 //while($get_data){
			$numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 9
		foreach ($id as $row) {
				$where2    = [];
				$item = $this->Items_model->get_data(array('item_id' => $row))->row();

	
				$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $item->item_code);
				$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $item->item_name);
				$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $item->last_selling_price_large_unit);
				$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $item->last_purchase_price_large_unit);
				  $no++; // Tambah 1 setiap kali looping
				  $numrow++; // Tambah 1 setiap kali looping
		}
			 
		//}
		
		// Set width
		$excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

		// Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
		// Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
		// Set judul file excel
		$excel->getActiveSheet(0)->setTitle("ITEMS");
		$excel->setActiveSheetIndex(0);
		
		// Proses file excel
		// $date_now = change_format_date(date_now(), 'Ymd');
        $currentDateTime = new DateTime();

// Format the current date and time as a string
        $formattedDateTime = $currentDateTime->format('YmdHis');
		$filename = trims($formattedDateTime).'.csv';
		

// 		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
// 		header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
// 		header('Cache-Control: max-age=0');
        $this->output->set_content_type('application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        $this->output->set_header('Content-Disposition: attachment; filename="' . $filename . '"');
        $this->output->set_header('Cache-Control: max-age=0');
		// $write = PHPExcel_IOFactory::createWriter($excel, 'Excel5');
		$write = new PHPExcel_Writer_CSV($excel);

        $filepath = 'assets/excels/upload_file/' . $filename;
		$write->save($filepath);
		$response = array(
            'status' => 'success',
            'message' => 'Export successful',
            'fileUrl' => base_url($filepath) // Adjust this based on your file structure
        );
        
        output_json($response);
		
	}
}
