<?php

/**
 * Users Controllers
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
require_once APPPATH."libraries/BaseController.php";
use libraries\BaseController;

class Dashboard extends BaseController
{
	
	/**
	 * Construcktor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();

		$this->auth->check_auth();

		$this->load->model("Dashboards_model");
		$this->load->model("Items_model");
		$this->load->model("Customers_model");
		$this->load->model("Sales_model");
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */
	public function index()
	{
		$data['content_title'] = 'Dashboard';

		$this->twiggy_display('adm/dashboard/index', $data);
	}



	/**
	 * Logout
	 */
	public function logout()
	{
		$this->session->sess_destroy();

		redirect('loginweb');
	}
}
